/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo.client;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import net.lakis.apollo.client.ClientShutdownHookup;
import net.lakis.apollo.config.SystemProperties;
import net.lakis.apollo.socket.SocketClient;
import net.lakis.apollo.socket.SocketGenerator;
import org.apache.commons.lang.exception.ExceptionUtils;

public class Client {
    private SocketClient socketClient;
    private PrintWriter out;
    private BufferedReader in;
    private ConsoleReader reader = new ConsoleReader();

    public Client() throws IOException {
        Runtime.getRuntime().addShutdownHook(new ClientShutdownHookup(this));
    }

    public void connect() {
        try {
            SocketGenerator socketGenerator = new SocketGenerator();
            this.socketClient = socketGenerator.generateClient();
            this.out = this.socketClient.getOutput();
            this.in = this.socketClient.getInput();
            this.println("Console successfully connected!");
        }
        catch (Exception e) {
            this.println("Console failed to connect!");
            if (this.socketClient != null) {
                this.socketClient.close();
            }
            this.socketClient = null;
        }
    }

    public void disconnect() {
        this.socketClient.close();
        this.socketClient = null;
        this.println("Console successfully disconnected!");
    }

    private void println(String msg) {
        try {
            if (this.reader == null) {
                System.out.println(msg);
            } else {
                this.reader.println((CharSequence)msg);
            }
        }
        catch (IOException e) {
            System.out.println(msg);
        }
    }

    public void loop() throws IOException {
        String line;
        this.reader.setHistory((History)new FileHistory(new File(SystemProperties.INSTANCE.getHistoryPath())));
        this.reloadOptions(this.reader);
        this.reader.setPrompt(SystemProperties.INSTANCE.getApolloName() + "> ");
        while ((line = this.reader.readLine()) != null) {
            Process process;
            String[] command;
            if ((line = line.trim()).length() == 0) continue;
            if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) break;
            if (line.equalsIgnoreCase("clear")) {
                this.reader.clearScreen();
                continue;
            }
            if (line.equalsIgnoreCase("start")) {
                try {
                    command = new String[]{SystemProperties.INSTANCE.getApolloScript(), "start"};
                    process = new ProcessBuilder(command).inheritIO().start();
                    process.waitFor();
                }
                catch (Exception e) {
                    this.println(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                continue;
            }
            if (line.equalsIgnoreCase("stop")) {
                try {
                    if (this.socketClient != null) {
                        this.disconnect();
                        this.reloadOptions(this.reader);
                    }
                    command = new String[]{SystemProperties.INSTANCE.getApolloScript(), "stop"};
                    process = new ProcessBuilder(command).inheritIO().start();
                    process.waitFor();
                }
                catch (Exception e) {
                    this.println(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                continue;
            }
            if (line.equalsIgnoreCase("status")) {
                try {
                    command = new String[]{SystemProperties.INSTANCE.getApolloScript(), "status"};
                    process = new ProcessBuilder(command).inheritIO().start();
                    process.waitFor();
                }
                catch (Exception e) {
                    this.println(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                if (this.socketClient == null) {
                    this.println("Console Disconnected!");
                    continue;
                }
                this.println("Console Connected!");
                continue;
            }
            if (line.equalsIgnoreCase("restart")) {
                try {
                    if (this.socketClient != null) {
                        this.disconnect();
                        this.reloadOptions(this.reader);
                    }
                    command = new String[]{SystemProperties.INSTANCE.getApolloScript(), "stop"};
                    process = new ProcessBuilder(command).inheritIO().start();
                    process.waitFor();
                }
                catch (Exception e) {
                    this.println(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                try {
                    command = new String[]{SystemProperties.INSTANCE.getApolloScript(), "start"};
                    process = new ProcessBuilder(command).inheritIO().start();
                    process.waitFor();
                }
                catch (Exception e) {
                    this.println(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                continue;
            }
            if (line.equalsIgnoreCase("connect")) {
                this.connect();
                this.reloadOptions(this.reader);
                continue;
            }
            if (line.equalsIgnoreCase("disconnect")) {
                this.disconnect();
                this.reloadOptions(this.reader);
                continue;
            }
            if (this.socketClient == null) {
                this.println("Console is disconnected. please connect it before sending any request!");
                continue;
            }
            this.out.println(line);
            this.redirectToConsole();
        }
    }

    private void redirectToConsole() {
        try {
            while (true) {
                String result;
                if ((result = this.in.readLine()) == null || this.socketClient == null) {
                    this.println("Connection lost!");
                    this.socketClient = null;
                    this.in = null;
                    this.out = null;
                    return;
                }
                if (result.equals("<<<end>>>")) {
                    return;
                }
                this.println(result);
            }
        }
        catch (IOException e) {
            this.println("Connection lost!");
            this.println(ExceptionUtils.getFullStackTrace((Throwable)e));
            this.socketClient = null;
            this.in = null;
            this.out = null;
            return;
        }
    }

    private void reloadOptions(ConsoleReader reader) throws IOException {
        Collection completers = reader.getCompleters();
        for (Completer c : completers) {
            reader.removeCompleter(c);
        }
        ArrayList<ArgumentCompleter> completers3d = new ArrayList<ArgumentCompleter>();
        ArrayList<Object> completers2d = new ArrayList<Object>();
        completers2d.add(new StringsCompleter(new String[]{"start"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"stop"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"status"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"restart"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"clear"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"connect"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"disconnect"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"quit"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        completers2d = new ArrayList();
        completers2d.add(new StringsCompleter(new String[]{"exit"}));
        completers2d.add(new NullCompleter());
        completers3d.add(new ArgumentCompleter(completers2d));
        if (this.socketClient != null) {
            String[][][] data;
            this.out.println("getoptions");
            String result = this.in.readLine();
            for (String[][] Arr3d : data = (String[][][])new Gson().fromJson(result, String[][][].class)) {
                completers2d = new ArrayList();
                for (String[] Arr2d : Arr3d) {
                    completers2d.add(new StringsCompleter(Arr2d));
                }
                completers2d.add(new NullCompleter());
                completers3d.add(new ArgumentCompleter(completers2d));
            }
        }
        reader.addCompleter((Completer)new AggregateCompleter(completers3d));
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public void setReader(ConsoleReader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void standaloneRequest(String cmd) {
        try (SocketClient socketClient = null;){
            SocketGenerator socketGenerator = new SocketGenerator();
            socketClient = socketGenerator.generateClient();
            PrintWriter out = socketClient.getOutput();
            BufferedReader in = socketClient.getInput();
            out.println(cmd);
            while (true) {
                String result;
                if ((result = in.readLine()) == null || socketClient == null) {
                    System.err.println("Connection lost!");
                    return;
                }
                if (result.equals("<<<end>>>")) {
                    return;
                }
                System.out.println(result);
                continue;
                break;
            }
        }
    }
}

