/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import net.lakis.apollo.IConsoleHandler;
import net.lakis.apollo.annotations.ConsoleKey;
import net.lakis.apollo.config.SystemProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ConsoleKey(value="config")
public abstract class AbstractConfigHandler<T>
implements IConsoleHandler {
    private static final Logger log = LogManager.getLogger(AbstractConfigHandler.class);
    private final Class<T> typeParameterClass;
    private T config;

    public AbstractConfigHandler(Class<T> typeParameterClass) throws InstantiationException, IllegalAccessException {
        this.typeParameterClass = typeParameterClass;
        this.reloadConfig();
    }

    @ConsoleKey(value="reload")
    public String reloadConfig() throws InstantiationException, IllegalAccessException {
        try {
            this.config = this.typeParameterClass.newInstance();
            for (Field field : this.typeParameterClass.getDeclaredFields()) {
                Object conf = null;
                try {
                    String confPath = SystemProperties.INSTANCE.getUserPath();
                    confPath = System.getProperty("user.dir", "D:\\test");
                    String path = confPath + "/conf/" + field.getName() + ".json";
                    FileInputStream inputStream = new FileInputStream(path);
                    try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));){
                        conf = new Gson().fromJson(reader, field.getType());
                    }
                }
                catch (Exception e) {
                    log.warn(field.getName() + ".json doesn't exist or corrupted");
                    conf = field.getType().newInstance();
                }
                field.setAccessible(true);
                field.set(this.config, conf);
            }
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            this.config = this.typeParameterClass.newInstance();
        }
        return "Configurations successfully reloaded.";
    }

    @ConsoleKey(value="print")
    public String print() {
        return this.config.toString();
    }

    @ConsoleKey(value="printJson")
    public String printJson() {
        return new GsonBuilder().setPrettyPrinting().create().toJson(this.config);
    }

    public T getConfig() {
        return this.config;
    }

    @Override
    public void onInit() {
    }
}

