/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo.server;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lakis.apollo.AbstractApollo;
import net.lakis.apollo.IConsoleHandler;
import net.lakis.apollo.annotations.ConsoleKey;
import net.lakis.apollo.annotations.ConsoleUsage;
import net.lakis.apollo.socket.Socket;
import org.apache.commons.lang.exception.ExceptionUtils;

public class SocketHandler
implements Runnable {
    private AbstractApollo service;
    private Socket socket;

    public SocketHandler(Socket socket, AbstractApollo service) {
        this.socket = socket;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = this.socket.getOutput();
            in = this.socket.getInput();
            while ((inputLine = in.readLine()) != null) {
                inputLine = inputLine.trim();
                List<IConsoleHandler> handlers = this.service.getConsoleHandlers();
                if (inputLine.equalsIgnoreCase("getoptions")) {
                    ArrayList ret = new ArrayList();
                    for (IConsoleHandler handler : handlers) {
                        ArrayList classOptions = new ArrayList();
                        ConsoleKey consoleKey = handler.getClass().getAnnotation(ConsoleKey.class);
                        if (consoleKey == null) continue;
                        ArrayList<String> methodOptions = new ArrayList<String>();
                        methodOptions.add(consoleKey.value());
                        classOptions.add(methodOptions);
                        methodOptions = new ArrayList();
                        for (Method method : handler.getClass().getMethods()) {
                            consoleKey = method.getAnnotation(ConsoleKey.class);
                            if (consoleKey == null) continue;
                            methodOptions.add(consoleKey.value());
                        }
                        if (methodOptions.size() <= 0) continue;
                        classOptions.add(methodOptions);
                        ret.add(classOptions);
                    }
                    out.println(new Gson().toJson(ret));
                    continue;
                }
                this.handle(out, inputLine);
            }
        }
        catch (Exception e) {
            out.println(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            this.socket.close();
        }
    }

    public List<String> splitLine(String line) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(line);
        while (m.find()) {
            list.add(m.group(1).replace("\"", ""));
        }
        return list;
    }

    private void handle(PrintWriter out, String inputLine) {
        try {
            StringBuilder sb = new StringBuilder();
            List<String> argsList = this.splitLine(inputLine);
            String[] args = new String[argsList.size()];
            args = argsList.toArray(args);
            for (IConsoleHandler o : this.service.getConsoleHandlers()) {
                ConsoleKey key = null;
                try {
                    key = o.getClass().getAnnotation(ConsoleKey.class);
                }
                catch (Exception e) {
                    continue;
                }
                if (key == null || !key.value().equalsIgnoreCase(args[0])) continue;
                if (args.length < 2) {
                    sb.append(args[0]);
                    sb.append(" requires a method: \n");
                    for (Method m : o.getClass().getMethods()) {
                        key = m.getAnnotation(ConsoleKey.class);
                        if (key == null) continue;
                        sb.append(key.value());
                        sb.append(" ");
                    }
                    sb.append("\n");
                    out.println(sb.toString());
                    out.println("<<<end>>>");
                    return;
                }
                for (Method m : o.getClass().getMethods()) {
                    key = m.getAnnotation(ConsoleKey.class);
                    if (key == null || !key.value().equalsIgnoreCase(args[1])) continue;
                    Class<?>[] params = m.getParameterTypes();
                    if (params.length != args.length - 2 && (params.length != args.length - 1 || params[0] != PrintWriter.class)) {
                        sb.append(args[0]);
                        sb.append(" ");
                        sb.append(args[1]);
                        if (m.getParameterTypes().length != 1) {
                            sb.append(" requires ");
                            sb.append(m.getParameterTypes().length);
                            sb.append(" parameters\n");
                        } else {
                            sb.append(" requires 1 parameter\n");
                        }
                        ConsoleUsage usage = m.getAnnotation(ConsoleUsage.class);
                        if (usage != null) {
                            sb.append("\nUsage: ");
                            sb.append(args[0]);
                            sb.append(" ");
                            sb.append(args[1]);
                            sb.append(" ");
                            sb.append(usage.value());
                            sb.append("\n");
                        }
                        out.println(sb.toString());
                        out.println("<<<end>>>");
                        return;
                    }
                    Object[] parameters = new Object[params.length];
                    int i = 0;
                    if (params.length == args.length - 1) {
                        parameters[i++] = out;
                    }
                    for (int j = 2; j < args.length; ++j) {
                        parameters[i++] = args[j];
                    }
                    if (params.length == args.length - 2) {
                        String ret = (String)m.invoke((Object)o, parameters);
                        out.println(ret);
                        out.println("<<<end>>>");
                    } else {
                        m.invoke((Object)o, parameters);
                    }
                    return;
                }
            }
            sb.append("Command not found: ");
            sb.append(inputLine);
            sb.append("\n");
            out.println(sb.toString());
        }
        catch (Exception e) {
            out.println(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        out.println("<<<end>>>");
    }
}

