/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo.socket;

import com.etsy.net.UnixDomainSocket;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import net.lakis.apollo.socket.SocketType;

public class Socket
implements Closeable {
    private SocketType socketType;
    private java.net.Socket socket;
    private UnixDomainSocket unixDomainSocket;
    private PrintWriter out;
    private BufferedReader in;

    public Socket(java.net.Socket socket) {
        this.socket = socket;
        this.socketType = SocketType.TCP;
    }

    public Socket(UnixDomainSocket unixDomainSocket) {
        this.unixDomainSocket = unixDomainSocket;
        this.socketType = SocketType.UNIX;
    }

    public PrintWriter getOutput() throws IOException {
        if (this.out == null) {
            switch (this.socketType) {
                case TCP: {
                    this.out = new PrintWriter(this.socket.getOutputStream(), true);
                    break;
                }
                case UNIX: {
                    this.out = new PrintWriter(this.unixDomainSocket.getOutputStream(), true);
                }
            }
        }
        return this.out;
    }

    public BufferedReader getInput() throws IOException {
        if (this.in == null) {
            switch (this.socketType) {
                case TCP: {
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    break;
                }
                case UNIX: {
                    this.in = new BufferedReader(new InputStreamReader(this.unixDomainSocket.getInputStream()));
                }
            }
        }
        return this.in;
    }

    @Override
    public void close() {
        try {
            switch (this.socketType) {
                case TCP: {
                    this.socket.close();
                }
                case UNIX: {
                    this.unixDomainSocket.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

