/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo.socket;

import com.etsy.net.UnixDomainSocketClient;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import net.lakis.apollo.socket.SocketType;

public class SocketClient
implements Closeable {
    private UnixDomainSocketClient unixDomainSocketClient;
    private Socket socket;
    private SocketType socketType;
    private PrintWriter out;
    private BufferedReader in;

    public SocketClient(String path) throws IOException {
        this.unixDomainSocketClient = new UnixDomainSocketClient(path, 1);
        this.socketType = SocketType.UNIX;
    }

    public SocketClient(String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(host, port);
        this.socketType = SocketType.TCP;
    }

    public PrintWriter getOutput() throws IOException {
        if (this.out == null) {
            switch (this.socketType) {
                case TCP: {
                    this.out = new PrintWriter(this.socket.getOutputStream(), true);
                    break;
                }
                case UNIX: {
                    this.out = new PrintWriter(this.unixDomainSocketClient.getOutputStream(), true);
                }
            }
        }
        return this.out;
    }

    public BufferedReader getInput() throws IOException {
        if (this.in == null) {
            switch (this.socketType) {
                case TCP: {
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    break;
                }
                case UNIX: {
                    this.in = new BufferedReader(new InputStreamReader(this.unixDomainSocketClient.getInputStream()));
                }
            }
        }
        return this.in;
    }

    @Override
    public void close() {
        try {
            switch (this.socketType) {
                case TCP: {
                    this.socket.close();
                }
                case UNIX: {
                    this.unixDomainSocketClient.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

