/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo.socket;

import java.io.IOException;
import java.net.UnknownHostException;
import net.lakis.apollo.config.SystemProperties;
import net.lakis.apollo.socket.SocketClient;
import net.lakis.apollo.socket.SocketServer;

public class SocketGenerator {
    private String path = SystemProperties.INSTANCE.getSocketFile();
    private String host = SystemProperties.INSTANCE.getSocketHost();
    private int port = SystemProperties.INSTANCE.getSocketPort();

    public SocketServer generateServer() throws Exception {
        if (this.path != null) {
            return new SocketServer(this.path);
        }
        return new SocketServer(this.host, this.port);
    }

    public SocketClient generateClient() throws Exception {
        if (this.path != null) {
            return this.generateClient(this.path);
        }
        return this.generateClient(this.host, this.port);
    }

    private SocketClient generateClient(String path) throws IOException {
        return new SocketClient(path);
    }

    private SocketClient generateClient(String host, int port) throws UnknownHostException, IOException {
        return new SocketClient(host, port);
    }
}

