/*
 * Decompiled with CFR 0.152.
 */
package net.lamberto.junit;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class GuiceJUnitRunner
extends BlockJUnit4ClassRunner {
    private Collection<Class<? extends Module>> modules;

    public GuiceJUnitRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    private Injector createInjectorFor(Collection<Class<? extends Module>> classes) throws InitializationError {
        return Guice.createInjector((Iterable)Collections2.transform(classes, (Function)new Function<Class<? extends Module>, Module>(){

            public Module apply(Class<? extends Module> module) {
                return module.newInstance();
            }
        }));
    }

    private Collection<Class<? extends Module>> getModulesFor(Class<?> module) throws InitializationError {
        GuiceModules annotation = module.getAnnotation(GuiceModules.class);
        return annotation == null ? null : Arrays.asList(annotation.value());
    }

    private Collection<Class<? extends Module>> getModulesFor(FrameworkMethod method) throws InitializationError {
        GuiceModules annotation = (GuiceModules)method.getAnnotation(GuiceModules.class);
        return annotation == null ? null : Arrays.asList(annotation.value());
    }

    private Collection<Class<? extends Module>> getModulesFor(FrameworkMethod method, Class<?> module) throws InitializationError {
        return (Collection)Optional.fromNullable(this.getModulesFor(method)).or(Optional.fromNullable(this.getModulesFor(module)).or(Collections.emptyList()));
    }

    protected Object createTest() throws Exception {
        return this.createInjectorFor(this.modules).getInstance(this.getTestClass().getJavaClass());
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        try {
            this.modules = this.getModulesFor(method, method.getDeclaringClass());
            super.runChild(method, notifier);
        }
        catch (InitializationError e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface GuiceModules {
        public Class<? extends Module>[] value();
    }
}

