/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.base;

public enum StringParser {
    INT(Integer::parseInt),
    SHORT(Short::parseShort),
    LONG(Long::parseLong),
    FLOAT(Float::parseFloat),
    DOUBLE(Double::parseDouble),
    CHAR(s -> {
        if (s.length() == 1) {
            return Character.valueOf(s.toCharArray()[0]);
        }
        throw new IllegalArgumentException("String length is not 1 (length: " + s.length() + "): " + s);
    }),
    STRING(s -> s);

    public final ParserInterface<?> parser;

    private StringParser(ParserInterface<?> parser) {
        this.parser = parser;
    }

    public static StringParser getObjectTypeParser(String typeName) {
        String typeClassName = typeName.substring(typeName.lastIndexOf(".") + 1);
        for (StringParser value : StringParser.values()) {
            if (!value.name().toLowerCase().contains(typeClassName.toLowerCase()) && !typeClassName.toLowerCase().contains(value.name().toLowerCase())) continue;
            return value;
        }
        throw new IllegalArgumentException("Unsupported Type: " + typeName);
    }

    @FunctionalInterface
    public static interface ParserInterface<R> {
        public R parse(String var1);
    }
}

