/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.base.runner;

import com.google.common.base.Defaults;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.lamgc.utils.base.ArgumentsProperties;
import net.lamgc.utils.base.runner.Argument;
import net.lamgc.utils.base.runner.ArgumentsRunnerConfig;
import net.lamgc.utils.base.runner.Command;
import net.lamgc.utils.base.runner.CommandMap;
import net.lamgc.utils.base.runner.StringParameterParser;
import net.lamgc.utils.base.runner.exception.CommandNotSpecifiedException;
import net.lamgc.utils.base.runner.exception.DeveloperRunnerException;
import net.lamgc.utils.base.runner.exception.IllegalCommandException;
import net.lamgc.utils.base.runner.exception.IllegalModifierException;
import net.lamgc.utils.base.runner.exception.InvalidParameterException;
import net.lamgc.utils.base.runner.exception.NoSuchCommandException;
import net.lamgc.utils.base.runner.exception.ParameterNoFoundException;
import net.lamgc.utils.base.runner.exception.ParseParameterException;
import net.lamgc.utils.base.runner.exception.RunnerException;

public class ArgumentsRunner {
    private static final Pattern COMMAND_NAME_CHECK_PATTERN = Pattern.compile("^[^ ]+$");
    private final ArgumentsRunnerConfig config;
    private final Class<?> runClass;
    private final CommandMap commandMap;

    public static Object run(Class<?> runClass, String[] args) {
        return new ArgumentsRunner(runClass, null).run(args);
    }

    public static Object run(Class<?> runClass, Object object, String[] args) throws RunnerException {
        return new ArgumentsRunner(runClass, null).run(object, args);
    }

    public static Object runInThisClass(String[] args) throws RunnerException {
        return ArgumentsRunner.runInThisClass(null, args);
    }

    public static Object runInThisClass(Object object, String[] args) throws RunnerException {
        try {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements.length < 3) {
                throw new DeveloperRunnerException(new IllegalStateException("Stack error"));
            }
            int callerElementIndex = 2;
            StackTraceElement caller = stackTraceElements[callerElementIndex];
            while (caller.getClassName().equals(stackTraceElements[1].getClassName()) && caller.getMethodName().equals(stackTraceElements[1].getMethodName())) {
                caller = stackTraceElements[++callerElementIndex];
            }
            Class<?> targetClass = ClassLoader.getSystemClassLoader().loadClass(caller.getClassName());
            return ArgumentsRunner.run(targetClass, object, args);
        }
        catch (ClassNotFoundException e) {
            throw new DeveloperRunnerException(e);
        }
    }

    public ArgumentsRunner(Class<?> runClass) {
        this(runClass, null);
    }

    public ArgumentsRunner(Class<?> runClass, ArgumentsRunnerConfig config) throws RunnerException {
        this.runClass = runClass;
        this.config = config == null ? new ArgumentsRunnerConfig() : config;
        this.commandMap = this.parseCommandMethodFromClass(runClass);
    }

    public Object run(String[] args) throws RunnerException {
        return this.run(null, args);
    }

    public Object run(Object object, String[] args) throws RunnerException {
        Method targetMethod;
        if (object != null && !this.runClass.isInstance(object)) {
            throw new DeveloperRunnerException(new IllegalArgumentException("The provided object is not an instance of runClass"));
        }
        if (Objects.requireNonNull(args).length == 0) {
            if (!this.commandMap.hasDefaultMethod()) {
                throw new CommandNotSpecifiedException();
            }
            targetMethod = this.commandMap.getDefaultMethod();
            object = null;
        } else {
            String command;
            String commandName = args[0];
            if (this.config.isCommandIgnoreCase()) {
                commandName = commandName.toLowerCase();
            }
            String string = command = object == null ? "Static." + commandName : commandName;
            if (!this.commandMap.containsKey(command)) {
                if (!this.commandMap.hasDefaultMethod()) {
                    throw new NoSuchCommandException(command);
                }
                targetMethod = this.commandMap.getDefaultMethod();
            } else {
                targetMethod = (Method)this.commandMap.get(command);
            }
            int modifiers = targetMethod.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalModifierException("Method is not public: " + targetMethod.getName());
            }
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalModifierException("Method is abstract: " + targetMethod.getName());
            }
        }
        String[] arguments = args.length <= 1 ? new String[]{} : Arrays.copyOfRange(args, 1, args.length);
        List<Object> paramList = this.generateParamListByFlag(targetMethod, arguments);
        Object[] params = new Object[targetMethod.getParameterTypes().length];
        paramList.toArray(params);
        try {
            return targetMethod.invoke(object, params);
        }
        catch (IllegalAccessException e) {
            throw new DeveloperRunnerException(e);
        }
        catch (InvocationTargetException e) {
            throw new DeveloperRunnerException(e.getTargetException());
        }
    }

    public Set<String> getCommandNames() {
        return this.commandMap == null ? null : new HashSet(this.commandMap.keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> generateParamListByFlag(Method method, String[] args) {
        ArgumentsProperties argsProp = new ArgumentsProperties(args);
        Parameter[] parameterTypes = method.getParameters();
        ArrayList<Object> paramList = new ArrayList<Object>(parameterTypes.length);
        int paramIndex = -1;
        for (Parameter paramType : parameterTypes) {
            ++paramIndex;
            Argument argumentAnnotation = paramType.getAnnotation(Argument.class);
            if (argumentAnnotation == null) {
                throw new InvalidParameterException("Parameter in method " + method.getName() + " without argument annotation (Index: " + paramIndex + ")");
            }
            if (!this.checkParametersType(paramType.getType())) {
                throw new InvalidParameterException("Method <" + method.getName() + "> Parameter has an unsupported type: " + paramType.getType() + " (Index: " + paramIndex + ")");
            }
            String paramName = argumentAnnotation.name();
            if (Strings.isNullOrEmpty((String)paramName)) {
                if (!paramType.isNamePresent()) throw new InvalidParameterException("Parameter name is empty. (MethodName: " + method.getName() + ", Index: " + paramIndex + ")");
                paramName = paramType.getName();
            }
            String typeName = paramType.getType().getTypeName();
            StringParameterParser<?> parameterParser = this.config.getStringParameterParser(paramType.getType());
            if (!argsProp.containsKey(paramName) && argumentAnnotation.force()) {
                throw new ParameterNoFoundException(method.getName(), paramIndex, paramName);
            }
            String paramValue = argsProp.getValue(paramName);
            if (Strings.isNullOrEmpty((String)paramValue) && !typeName.equals("boolean") && !typeName.equals(Boolean.class.getTypeName())) {
                if (argumentAnnotation.force()) throw new ParameterNoFoundException(method.getName(), paramIndex, paramName);
                String defaultValue = argumentAnnotation.defaultValue();
                if (!Strings.isNullOrEmpty((String)defaultValue)) {
                    paramValue = defaultValue;
                } else {
                    if (this.config.isStrictDefaultCheck()) {
                        throw new InvalidParameterException("Parameter force is false but has no default value. (Index: " + paramIndex + ")");
                    }
                    if (this.config.hasStringParameterParser(paramType.getType())) {
                        paramList.add(parameterParser.defaultValue());
                        continue;
                    }
                    paramList.add(Defaults.defaultValue(paramType.getType()));
                    continue;
                }
            }
            if ((typeName.equals("boolean") || typeName.equals(Boolean.class.getTypeName())) && !this.config.hasStringParameterParser((Type)((Object)Boolean.class))) {
                if (paramValue == null) {
                    paramList.add(Boolean.FALSE);
                    continue;
                }
                if (paramValue.isEmpty()) {
                    paramList.add(Boolean.TRUE);
                    continue;
                }
                paramValue = paramValue.trim().toLowerCase();
                if (this.config.getTrueFlag().contains(paramValue)) {
                    paramList.add(Boolean.TRUE);
                    continue;
                }
                paramList.add(Boolean.FALSE);
                continue;
            }
            if (typeName.equals(String.class.getTypeName()) && !this.config.hasStringParameterParser((Type)((Object)String.class))) {
                paramList.add(paramValue);
                continue;
            }
            try {
                paramList.add(parameterParser.parse(paramValue));
            }
            catch (Throwable e) {
                if (!this.config.isUseDefaultValueInsteadOfException()) throw new ParseParameterException(paramName, paramValue, typeName, e);
                paramList.add(parameterParser.defaultValue());
            }
        }
        return paramList;
    }

    private CommandMap parseCommandMethodFromClass(Class<?> clazz) throws RunnerException {
        int classModifier = clazz.getModifiers();
        if (!Modifier.isPublic(classModifier)) {
            throw new IllegalModifierException("Class is not public");
        }
        if (Modifier.isAbstract(classModifier) || Modifier.isInterface(classModifier)) {
            throw new IllegalModifierException("Class is abstract or interface");
        }
        Method[] methods = clazz.getDeclaredMethods();
        CommandMap commandMethodMap = new CommandMap(methods.length);
        for (Method method : methods) {
            Command commandAnnotation;
            if (ArgumentsRunner.isMainMethod(method) || (commandAnnotation = method.getDeclaredAnnotation(Command.class)) == null) continue;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalModifierException("Method is not public: " + method.getName());
            }
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalModifierException("Method is abstract: " + method.getName());
            }
            String commandName = commandAnnotation.commandName();
            if (Strings.isNullOrEmpty((String)commandName)) {
                commandName = method.getName();
            }
            if (!COMMAND_NAME_CHECK_PATTERN.matcher(commandName).matches()) {
                throw new IllegalCommandException("Illegal command name: " + commandName);
            }
            if (!commandMethodMap.hasDefaultMethod() && commandAnnotation.defaultCommand() && method.getAnnotatedParameterTypes().length == 0 && Modifier.isStatic(modifiers)) {
                commandMethodMap.setDefaultMethod(method);
            }
            if (commandMethodMap.containsKey(commandName)) {
                throw new IllegalCommandException("There are multiple methods for the same command: " + commandName);
            }
            if (commandMethodMap.containsValue(method)) {
                throw new IllegalCommandException("Multiple command names exist in the same method: " + commandName);
            }
            if (this.config.isCommandIgnoreCase()) {
                commandName = commandName.toLowerCase();
            }
            commandMethodMap.put(Modifier.isStatic(modifiers) ? "Static." + commandName : commandName, method);
        }
        return commandMethodMap;
    }

    private static boolean isMainMethod(Method method) {
        int modifier = method.getModifiers();
        if (Modifier.isPublic(modifier) && Modifier.isStatic(modifier) && method.getName().equals("main") && method.getReturnType().isAssignableFrom(Void.TYPE)) {
            Class<?>[] typeClass = method.getParameterTypes();
            return typeClass.length == 1 && typeClass[0].isAssignableFrom(String[].class);
        }
        return false;
    }

    private boolean checkParametersType(Type type) {
        String typeName = type.getTypeName();
        return this.config.hasStringParameterParser(type) || typeName.equals("boolean") || typeName.equals(Boolean.class.getTypeName()) || type.getTypeName().equals(String.class.getTypeName());
    }
}

