/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.base.runner;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import net.lamgc.utils.base.runner.StringParameterParser;
import net.lamgc.utils.base.runner.StringParameterParserMap;
import net.lamgc.utils.base.runner.parser.CharParser;
import net.lamgc.utils.base.runner.parser.DoubleParser;
import net.lamgc.utils.base.runner.parser.FloatParser;
import net.lamgc.utils.base.runner.parser.IntegerParser;
import net.lamgc.utils.base.runner.parser.LongParser;
import net.lamgc.utils.base.runner.parser.ShortParser;

public class ArgumentsRunnerConfig
implements Serializable {
    private boolean commandIgnoreCase = false;
    private boolean strictDefaultCheck = false;
    private Set<String> trueFlag = new HashSet<String>(4);
    private boolean useDefaultValueInsteadOfException = false;
    private StringParameterParserMap parameterParserMap = new StringParameterParserMap();

    public ArgumentsRunnerConfig() {
        this.initialConfig();
    }

    private void initialConfig() {
        this.addTrueFlag("t");
        this.addTrueFlag("true");
        this.addTrueFlag("y");
        this.addTrueFlag("yes");
        this.addStringParameterParser(new IntegerParser());
        this.addStringParameterParser(new ShortParser());
        this.addStringParameterParser(new LongParser());
        this.addStringParameterParser(new FloatParser());
        this.addStringParameterParser(new DoubleParser());
        this.addStringParameterParser(new CharParser());
    }

    public void addStringParameterParser(StringParameterParser<?> parser) {
        this.parameterParserMap.addParser(parser);
    }

    public void removeStringParameterParser(Type type) {
        this.parameterParserMap.removeParser(type);
    }

    public StringParameterParser<?> getStringParameterParser(Type type) {
        return this.parameterParserMap.getParser(type);
    }

    public boolean hasStringParameterParser(Type type) {
        return this.parameterParserMap.hasParser(type);
    }

    public void addTrueFlag(String flag) {
        this.trueFlag.add(flag.trim().toLowerCase());
    }

    public boolean removeTrueFlag(String flag) {
        return this.trueFlag.remove(flag.trim().toLowerCase());
    }

    public Set<String> getTrueFlag() {
        return new HashSet<String>(this.trueFlag);
    }

    public boolean isCommandIgnoreCase() {
        return this.commandIgnoreCase;
    }

    public void setCommandIgnoreCase(boolean commandIgnoreCase) {
        this.commandIgnoreCase = commandIgnoreCase;
    }

    public boolean isStrictDefaultCheck() {
        return this.strictDefaultCheck;
    }

    public void setStrictDefaultCheck(boolean strictDefaultCheck) {
        this.strictDefaultCheck = strictDefaultCheck;
    }

    public boolean isUseDefaultValueInsteadOfException() {
        return this.useDefaultValueInsteadOfException;
    }

    public void setUseDefaultValueInsteadOfException(boolean useDefaultValueInsteadOfException) {
        this.useDefaultValueInsteadOfException = useDefaultValueInsteadOfException;
    }
}

