/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import net.lamgc.utils.encrypt.EncryptUtils;

public final class AESEncrypt {
    private static final String Algorithm = "AES";

    private AESEncrypt() {
    }

    public static SecretKey getSecretKey(String encodeRules, int keySize) {
        return AESEncrypt.getSecretKey(encodeRules.getBytes(), keySize);
    }

    public static SecretKey getSecretKey(byte[] encodeRules, int keySize) {
        return EncryptUtils.getSecretKey(encodeRules, keySize, Algorithm);
    }

    static SecretKey BytesToSecretKey(byte[] keyEncode) {
        return EncryptUtils.BytesToSecretKey(keyEncode, Algorithm);
    }

    public static byte[] encrypt(byte[] data, SecretKey key) throws NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(Algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, SecretKey key) throws NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(Algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        cipher.init(2, key);
        return cipher.doFinal(data);
    }
}

