/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public final class DiffieHellmanEncrypt {
    private static final String KEY_ALGORITHM = "DH";
    public static final int DEFAULT_KEY_SIZE = 512;
    private KeyPair keyPair;

    public DiffieHellmanEncrypt() {
        this.initKey(512);
    }

    public DiffieHellmanEncrypt(int keySize) {
        this.initKey(keySize);
    }

    public void initKey(int keySize) {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        keyPairGenerator.initialize(keySize);
        this.keyPair = keyPairGenerator.generateKeyPair();
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    public SecretKey getSecretKey(byte[] publicKey, Algorithm algorithm) throws InvalidKeyException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            return this.getSecretKey(pubKey, algorithm);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public SecretKey getSecretKey(PublicKey publicKey, Algorithm algorithm) throws InvalidKeyException {
        try {
            KeyAgreement keyAgree = KeyAgreement.getInstance(KEY_ALGORITHM);
            keyAgree.init(this.keyPair.getPrivate());
            keyAgree.doPhase(publicKey, true);
            return keyAgree.generateSecret(algorithm.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        System.setProperty("jdk.crypto.KeyAgreement.legacyKDF", "true");
    }

    public static enum Algorithm {
        AES("AES"),
        RC2("RC2"),
        RC4("ARCFOUR"),
        Blowfish("Blowfish"),
        DES("DES"),
        DES_ede("DESede"),
        HmacMD5("HmacMD5"),
        HmacSHA1("HmacSHA1"),
        HmacSHA256("HmacSHA256"),
        HmacSHA384("HmacSHA384"),
        HmacSHA512("HmacSHA512");

        public final String algorithmName;

        private Algorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }
    }
}

