/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptUtils {
    public static SecretKey BytesToSecretKey(byte[] keyEncode, String algorithm) {
        Objects.requireNonNull(keyEncode);
        Objects.requireNonNull(algorithm);
        return new SecretKeySpec(keyEncode, algorithm);
    }

    public static SecretKey getSecretKey(byte[] encodeRules, int keySize, String keyAlgorithm) throws IllegalStateException {
        KeyGenerator keygen;
        if (keySize <= 0) {
            keySize = 128;
        }
        try {
            keygen = KeyGenerator.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        keygen.init(keySize, new SecureRandom(encodeRules));
        return EncryptUtils.BytesToSecretKey(keygen.generateKey().getEncoded(), keyAlgorithm);
    }
}

