/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import net.lamgc.utils.encrypt.EncryptUtils;

public final class HmacEncryptUtils {
    private HmacEncryptUtils() {
    }

    public static byte[] encrypt(byte[] data, SecretKey key, Algorithm algorithm) throws InvalidKeyException {
        Objects.requireNonNull(data);
        Objects.requireNonNull(key);
        Objects.requireNonNull(algorithm);
        try {
            Mac mac = Mac.getInstance(algorithm.algorithmName);
            mac.init(key);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey getSecretKey(byte[] keyRules, int keySize, Algorithm algorithm) {
        return EncryptUtils.getSecretKey(keyRules, keySize, algorithm.algorithmName);
    }

    public static enum Algorithm {
        HmacMD5("HmacMD5"),
        HmacSHA1("HmacSHA1"),
        HmacSHA224("HmacSHA224"),
        HmacSHA256("HmacSHA256"),
        HmacSHA384("HmacSHA384"),
        HmacSHA512("HmacSHA512");

        public final String algorithmName;

        private Algorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }
    }
}

