/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class RSAEncrypt {
    public static int DEFAULT_KEY_SIZE = 3072;

    private RSAEncrypt() {
    }

    public static KeyPair getKeyPair(int keySize) {
        KeyPairGenerator keyPairGen;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        keyPairGen.initialize(keySize, new SecureRandom());
        return keyPairGen.generateKeyPair();
    }

    public static RSAPublicKey bytesToRSAPublicKey(byte[] keyBytes) throws InvalidKeySpecException {
        try {
            return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static RSAPrivateKey bytesToRSAPrivateKey(byte[] keyBytes) throws InvalidKeySpecException {
        try {
            return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] encrypt(RSAPublicKey publicKey, byte[] plainTextData) throws NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] output;
        Objects.requireNonNull(publicKey);
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            output = cipher.doFinal(plainTextData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return output;
    }

    public static byte[] encrypt(RSAPrivateKey privateKey, byte[] plainTextData) throws NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] output;
        Objects.requireNonNull(privateKey);
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, privateKey);
            output = cipher.doFinal(plainTextData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return output;
    }

    public static byte[] decrypt(RSAPrivateKey privateKey, byte[] cipherData) throws NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] output;
        Objects.requireNonNull(privateKey);
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            output = cipher.doFinal(cipherData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return output;
    }

    public static byte[] decrypt(RSAPublicKey publicKey, byte[] cipherData) throws NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] output;
        Objects.requireNonNull(publicKey);
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, publicKey);
            output = cipher.doFinal(cipherData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return output;
    }
}

