/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import net.lamgc.utils.encrypt.AESEncrypt;
import net.lamgc.utils.encrypt.RSAEncrypt;

public final class RSAEncryptWithAES {
    private RSAEncryptWithAES() {
    }

    public static byte[] encrypt(byte[] data, RSAPrivateKey privateKey) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchPaddingException {
        ByteBuffer buf = ByteBuffer.allocate(data.length + 2048);
        byte[] keyRules = new byte[512];
        new SecureRandom().nextBytes(keyRules);
        SecretKey aesKey = AESEncrypt.getSecretKey(keyRules, 256);
        byte[] keyData = RSAEncrypt.encrypt(privateKey, aesKey.getEncoded());
        buf.putInt(keyData.length);
        buf.put(keyData);
        buf.put(AESEncrypt.encrypt(data, aesKey));
        byte[] arr = buf.array();
        return Arrays.copyOf(arr, buf.position());
    }

    public static byte[] encrypt(byte[] data, RSAPublicKey publicKey) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchPaddingException {
        ByteBuffer buf = ByteBuffer.allocate(data.length + 2048);
        byte[] keyRules = new byte[512];
        new SecureRandom().nextBytes(keyRules);
        SecretKey aesKey = AESEncrypt.getSecretKey(keyRules, 256);
        byte[] keyData = RSAEncrypt.encrypt(publicKey, aesKey.getEncoded());
        buf.putInt(keyData.length);
        buf.put(keyData);
        buf.put(AESEncrypt.encrypt(data, aesKey));
        byte[] arr = buf.array();
        return Arrays.copyOf(arr, buf.position());
    }

    public static byte[] decrypt(byte[] data, RSAPublicKey publicKey) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchPaddingException {
        ByteBuffer buf = ByteBuffer.wrap(data);
        byte[] keyData = new byte[buf.getInt()];
        buf.get(keyData);
        SecretKey aesKey = AESEncrypt.BytesToSecretKey(RSAEncrypt.decrypt(publicKey, keyData));
        byte[] encryptData = new byte[buf.capacity() - buf.position()];
        buf.get(encryptData);
        return AESEncrypt.decrypt(encryptData, aesKey);
    }

    public static byte[] decrypt(byte[] data, RSAPrivateKey privateKey) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchPaddingException {
        ByteBuffer buf = ByteBuffer.wrap(data);
        byte[] keyData = new byte[buf.getInt()];
        buf.get(keyData);
        SecretKey aesKey = AESEncrypt.BytesToSecretKey(RSAEncrypt.decrypt(privateKey, keyData));
        byte[] encryptData = new byte[buf.capacity() - buf.position()];
        buf.get(encryptData);
        return AESEncrypt.decrypt(encryptData, aesKey);
    }
}

