/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.encrypt;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSASign {
    private RSASign() {
    }

    public static byte[] sign(byte[] content, byte[] privateKey, SignAlgorithm algorithm) throws SignatureException, InvalidKeyException, InvalidKeySpecException {
        Signature signature;
        PrivateKey priKey;
        PKCS8EncodedKeySpec privatePKCS8 = new PKCS8EncodedKeySpec(privateKey);
        try {
            priKey = KeyFactory.getInstance("RSA").generatePrivate(privatePKCS8);
            signature = Signature.getInstance(algorithm.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        signature.initSign(priKey);
        signature.update(content);
        return signature.sign();
    }

    public static byte[] sign(byte[] content, RSAPrivateKey privateKey, SignAlgorithm algorithm) throws InvalidKeySpecException, SignatureException, InvalidKeyException {
        return RSASign.sign(content, privateKey.getEncoded(), algorithm);
    }

    public static boolean checkSign(byte[] content, byte[] sign, byte[] publicKey, SignAlgorithm algorithm) throws InvalidKeySpecException, InvalidKeyException, SignatureException {
        Signature signature;
        PublicKey pubKey;
        try {
            pubKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
            signature = Signature.getInstance(algorithm.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        signature.initVerify(pubKey);
        signature.update(content);
        return signature.verify(sign);
    }

    public static boolean checkSign(byte[] content, byte[] sign, RSAPublicKey publicKey, SignAlgorithm algorithm) throws InvalidKeySpecException, InvalidKeyException, SignatureException {
        return RSASign.checkSign(content, sign, publicKey.getEncoded(), algorithm);
    }

    public static enum SignAlgorithm {
        MD2("MD2withRSA"),
        MD5("MD5withRSA"),
        SHA1("SHA1withRSA"),
        SHA224("SHA224withRSA"),
        SHA256("SHA256withRSA"),
        SHA384("SHA384withRSA"),
        SHA512("SHA512withRSA");

        public final String algorithmName;

        private SignAlgorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }
    }
}

