/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.event;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import net.lamgc.utils.event.EventExecutor;
import net.lamgc.utils.event.EventHandler;
import net.lamgc.utils.event.EventHandlerList;
import net.lamgc.utils.event.EventObject;

public class BasicEventHandlerList
implements EventHandlerList {
    private Hashtable<Class<? extends EventObject>, HashSet<Method>> eventMethodMap = new Hashtable();

    @Override
    public Set<Method> getEventHandlerMethod(Class<? extends EventObject> eventObject) {
        HashSet<Method> methods = new HashSet<Method>();
        this.eventMethodMap.keySet().forEach(clazz -> {
            if (clazz.isAssignableFrom(eventObject)) {
                methods.addAll((Collection)this.eventMethodMap.get(clazz));
            }
        });
        return methods;
    }

    @Override
    public void addEventHandler(Class<? extends EventHandler> eventHandler) throws IllegalAccessException {
        Method[] methods;
        int classModifier = eventHandler.getModifiers();
        if (!Modifier.isPublic(classModifier)) {
            throw new IllegalAccessException("class is not public");
        }
        if (Modifier.isInterface(classModifier) || Modifier.isAbstract(classModifier)) {
            throw new IllegalStateException("Class is an interface or abstract");
        }
        for (Method method : methods = eventHandler.getDeclaredMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!EventExecutor.checkMethod(method)) continue;
            this.addEventHandlerMethod(parameterTypes[0].asSubclass(EventObject.class), method);
        }
    }

    @Override
    public void addEventHandlerMethod(Class<? extends EventObject> eventObject, Method eventHandlerMethod) {
        if (!this.eventMethodMap.containsKey(eventObject)) {
            this.eventMethodMap.put(eventObject, new HashSet());
        }
        this.eventMethodMap.get(eventObject).add(eventHandlerMethod);
    }

    @Override
    public void removeEventHandler(Class<? extends EventHandler> handler) {
        Method[] methods;
        for (Method method : methods = handler.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || (parameterTypes = method.getParameterTypes()).length != 1 || !EventObject.class.isAssignableFrom(parameterTypes[0])) continue;
            this.eventMethodMap.get(parameterTypes[0]).remove(method);
        }
    }
}

