/*
 * Decompiled with CFR 0.152.
 */
package net.lamgc.utils.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.lamgc.utils.event.BasicEventHandlerList;
import net.lamgc.utils.event.EventHandler;
import net.lamgc.utils.event.EventHandlerList;
import net.lamgc.utils.event.EventHandlerObjectMap;
import net.lamgc.utils.event.EventInvokeException;
import net.lamgc.utils.event.EventObject;
import net.lamgc.utils.event.EventUncaughtExceptionHandler;
import net.lamgc.utils.event.HashHandlerObjectMap;
import net.lamgc.utils.event.NotAccepted;

public class EventExecutor {
    private final EventHandlerList eventHandlerList;
    private final EventHandlerObjectMap eventHandlerObjectMap;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final AtomicReference<Thread.UncaughtExceptionHandler> exceptionHandler = new AtomicReference();
    private final AtomicReference<EventUncaughtExceptionHandler> eventExceptionHandler = new AtomicReference();
    private final AtomicBoolean enableEventResend = new AtomicBoolean();
    private static final ThreadLocal<EventExecutor> threadEventExecutor = new ThreadLocal();
    private static final ThreadLocal<EventHandler> threadEventHandler = new ThreadLocal();
    private static final ThreadLocal<EventObject> threadEventObject = new ThreadLocal();

    public EventExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this(threadPoolExecutor, null, null);
    }

    public EventExecutor(ThreadPoolExecutor threadPoolExecutor, EventHandlerList eventHandlerList, EventHandlerObjectMap eventHandlerObjectMap) {
        this.threadPoolExecutor = threadPoolExecutor;
        ThreadFactory threadFactory = this.threadPoolExecutor.getThreadFactory();
        this.threadPoolExecutor.setThreadFactory(r -> {
            Thread newThread = threadFactory.newThread(r);
            if (newThread.getUncaughtExceptionHandler() == newThread.getThreadGroup()) {
                newThread.setUncaughtExceptionHandler((t, e) -> {
                    EventUncaughtExceptionHandler eventUncaughtHandler;
                    if (e instanceof EventInvokeException && (eventUncaughtHandler = this.eventExceptionHandler.get()) != null) {
                        EventInvokeException exception = (EventInvokeException)e;
                        eventUncaughtHandler.exceptionHandler(t, exception.getHandler(), exception.getHandlerMethod(), exception.getEventObject(), exception.getCause());
                        return;
                    }
                    Thread.UncaughtExceptionHandler threadExceptionHandler = this.exceptionHandler.get();
                    if (threadExceptionHandler != null) {
                        threadExceptionHandler.uncaughtException(t, e);
                    }
                });
            }
            return newThread;
        });
        this.eventHandlerList = eventHandlerList != null ? eventHandlerList : new BasicEventHandlerList();
        this.eventHandlerObjectMap = eventHandlerObjectMap != null ? eventHandlerObjectMap : new HashHandlerObjectMap();
    }

    public void addHandler(EventHandler handler) throws IllegalAccessException {
        this.eventHandlerObjectMap.addHandlerObject(handler);
        this.eventHandlerList.addEventHandler(handler.getClass());
    }

    public void removeHandler(EventHandler handler) {
        if (!this.eventHandlerObjectMap.removeHandlerObject(handler)) {
            this.eventHandlerList.removeEventHandler(handler);
        }
    }

    public void executor(EventObject eventObject) {
        Set<Method> eventHandlerMethod = this.eventHandlerList.getEventHandlerMethod(eventObject.getClass());
        if (eventHandlerMethod == null) {
            return;
        }
        eventHandlerMethod.forEach(method -> {
            Set<EventHandler> handlerSet = this.eventHandlerObjectMap.getHandlerObject(method.getDeclaringClass());
            this.threadPoolExecutor.execute(() -> handlerSet.forEach(handler -> this.executeEvent((EventHandler)handler, eventObject, (Method)method, null)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executorSync(EventObject eventObject) throws InterruptedException {
        Set<Method> eventHandlerMethod = this.eventHandlerList.getEventHandlerMethod(eventObject.getClass());
        if (eventHandlerMethod == null) {
            return;
        }
        AtomicInteger executeCount = new AtomicInteger();
        eventHandlerMethod.forEach(method -> {
            Set<EventHandler> handlerSet = this.eventHandlerObjectMap.getHandlerObject(method.getDeclaringClass());
            handlerSet.forEach(handler -> this.executeEvent((EventHandler)handler, eventObject, (Method)method, executeCount));
        });
        if (executeCount.get() != 0) {
            AtomicInteger atomicInteger = executeCount;
            synchronized (atomicInteger) {
                executeCount.wait();
            }
        }
    }

    public int executor(EventHandler handler, EventObject eventObject) throws IllegalAccessException {
        Class<?> handlerClass = handler.getClass();
        int classModifier = handlerClass.getModifiers();
        if (!Modifier.isPublic(classModifier)) {
            throw new IllegalAccessException("class is not public");
        }
        Method[] methods = handlerClass.getDeclaredMethods();
        int invokeCount = 0;
        for (Method method : methods) {
            if (!EventExecutor.checkMethod(method, eventObject)) continue;
            this.executeEvent(handler, eventObject, method, null);
            ++invokeCount;
        }
        return invokeCount;
    }

    public void setEnableEventResend(boolean enable) {
        this.enableEventResend.set(enable);
    }

    private void executeEvent(EventHandler handler, EventObject event, Method eventMethod, AtomicInteger executeCount) {
        if (executeCount == null) {
            this.threadPoolExecutor.execute(() -> {
                if (this.enableEventResend.get()) {
                    EventExecutor.setThreadResendInfo(this, handler, event);
                }
                this.createEventTask(handler, event, eventMethod).run();
                EventExecutor.clearThreadResendInfo();
            });
        } else {
            executeCount.incrementAndGet();
            this.threadPoolExecutor.execute(() -> {
                try {
                    if (this.enableEventResend.get()) {
                        EventExecutor.setThreadResendInfo(this, handler, event);
                    }
                    this.createEventTask(handler, event, eventMethod).run();
                }
                finally {
                    int count;
                    if (this.enableEventResend.get()) {
                        EventExecutor.clearThreadResendInfo();
                    }
                    if ((count = executeCount.decrementAndGet()) == 0) {
                        AtomicInteger atomicInteger = executeCount;
                        synchronized (atomicInteger) {
                            executeCount.notifyAll();
                        }
                    }
                }
            });
        }
    }

    private Runnable createEventTask(EventHandler handler, EventObject event, Method eventMethod) {
        return () -> {
            try {
                eventMethod.invoke((Object)handler, event);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new EventInvokeException(handler, eventMethod, event, e.getCause());
            }
        };
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPoolExecutor.awaitTermination(timeout, unit);
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.exceptionHandler.set(handler);
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler.get();
    }

    public List<Runnable> shutdown(boolean shutdownNow) {
        if (shutdownNow) {
            return this.threadPoolExecutor.shutdownNow();
        }
        this.threadPoolExecutor.shutdown();
        return null;
    }

    public void setEventUncaughtExceptionHandler(EventUncaughtExceptionHandler handler) {
        this.eventExceptionHandler.set(handler);
    }

    private static void setThreadResendInfo(EventExecutor executor, EventHandler currentHandler, EventObject currentObject) {
        threadEventExecutor.set(Objects.requireNonNull(executor));
        threadEventHandler.set(Objects.requireNonNull(currentHandler));
        threadEventObject.set(Objects.requireNonNull(currentObject));
    }

    private static void clearThreadResendInfo() {
        threadEventExecutor.set(null);
        threadEventHandler.set(null);
        threadEventObject.set(null);
    }

    public static void resendCurrentEvent() {
        EventExecutor executor = threadEventExecutor.get();
        if (executor == null) {
            throw new UnsupportedOperationException("Resend not enabled");
        }
        try {
            executor.executor(threadEventHandler.get(), threadEventObject.get());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean checkMethod(Method method) {
        return EventExecutor.checkMethod(method, null);
    }

    private static boolean checkMethod(Method method, EventObject eventObject) {
        int methodModifiers = method.getModifiers();
        if (!Modifier.isPublic(methodModifiers)) {
            return false;
        }
        Class<?>[] types = method.getParameterTypes();
        if (types.length != 1) {
            return false;
        }
        if (eventObject == null ? !EventObject.class.isAssignableFrom(types[0]) : !types[0].isAssignableFrom(eventObject.getClass())) {
            return false;
        }
        return method.getDeclaredAnnotation(NotAccepted.class) == null;
    }

    protected void finalize() {
        this.threadPoolExecutor.shutdownNow();
    }
}

