/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.hexutils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.lbruun.hexutils.HexConversionException;

public class Hex {
    public static final char[] HEX_CHARS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] HEX_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String HEX_REGEXP_CHARCLASS = "[0-9A-Fa-f]";

    private Hex() {
    }

    private static int putHexIntoCharArray(byte b, char[] target, int targetStartPos, HexCase caseType) {
        int octet = b & 0xFF;
        char[] hexArray = caseType == HexCase.UPPER ? HEX_CHARS_UPPER : HEX_CHARS_LOWER;
        target[targetStartPos] = hexArray[octet >>> 4];
        target[targetStartPos + 1] = hexArray[octet & 0xF];
        return targetStartPos + 2;
    }

    private static void putHexIntoOutputStream(byte b, OutputStream os, HexCase caseType) throws IOException {
        int octet = b & 0xFF;
        char[] hexArray = caseType == HexCase.UPPER ? HEX_CHARS_UPPER : HEX_CHARS_LOWER;
        os.write((byte)hexArray[octet >>> 4]);
        os.write((byte)hexArray[octet & 0xF]);
    }

    public static char[] byteToHex(byte b, HexCase caseType) {
        char[] hexChars = new char[2];
        Hex.putHexIntoCharArray(b, hexChars, 0, caseType);
        return hexChars;
    }

    public static char[] bytesToHex(byte[] bytes, HexCase caseType, String delim) {
        Hex.delimiterCheck(delim);
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return new char[0];
        }
        Objects.requireNonNull(caseType, "caseType cannot be null");
        int delimLength = delim != null ? delim.length() : 0;
        int noOfDelims = bytes.length - 1;
        char[] hexChars = new char[bytes.length * 2 + noOfDelims * delimLength];
        int arrPos = 0;
        for (int i = 0; i < bytes.length; ++i) {
            arrPos = Hex.putHexIntoCharArray(bytes[i], hexChars, arrPos, caseType);
            if (i >= bytes.length - 1 || delim == null || delim.isEmpty()) continue;
            for (int j = 0; j < delim.length(); ++j) {
                hexChars[arrPos + j] = delim.charAt(j);
            }
            arrPos += delim.length();
        }
        return hexChars;
    }

    public static String bytesToHexStr(byte[] bytes, HexCase caseType, String delim) {
        char[] chars = Hex.bytesToHex(bytes, caseType, delim);
        if (chars == null) {
            return null;
        }
        return new String(chars);
    }

    public static String bytesToHexStr(byte[] bytes, HexCase caseType) {
        char[] chars = Hex.bytesToHex(bytes, caseType, null);
        if (chars == null) {
            return null;
        }
        return new String(chars);
    }

    public static StringBuilder bytesToHexStr(byte[] bytes, HexCase caseType, String delim, StringBuilder sb) {
        Objects.requireNonNull(sb, "Argument sb must not be null");
        char[] chars = Hex.bytesToHex(bytes, caseType, delim);
        if (chars == null) {
            return sb;
        }
        sb.append(chars);
        return sb;
    }

    public static StringBuilder bytesToHexStr(byte[] bytes, HexCase caseType, StringBuilder sb) {
        return Hex.bytesToHexStr(bytes, caseType, null, sb);
    }

    private static void bytesToHexStreaming(InputStream is, OutputStream os, HexCase caseType, String delim, int maxCharsPerLine) throws IOException {
        int b;
        Hex.delimiterCheck(delim);
        byte[] lineFeed = System.lineSeparator().getBytes(StandardCharsets.US_ASCII);
        byte[] delimBytes = null;
        int delimLen = 0;
        if (delim != null) {
            delimBytes = delim.getBytes(StandardCharsets.US_ASCII);
            delimLen = delimBytes.length;
        }
        int maxBytesPerLine = (maxCharsPerLine + delimLen) / (delimLen + 2);
        boolean firstLineByteWritten = false;
        int bytesWritten = 0;
        while ((b = is.read()) != -1) {
            if (delimBytes != null) {
                if (firstLineByteWritten) {
                    os.write(delimBytes);
                } else {
                    firstLineByteWritten = true;
                }
            }
            Hex.putHexIntoOutputStream((byte)b, os, caseType);
            if (maxCharsPerLine == -1 || ++bytesWritten != maxBytesPerLine) continue;
            os.write(lineFeed);
            firstLineByteWritten = false;
            bytesWritten = 0;
        }
    }

    public static void bytesToHexStreaming(InputStream is, OutputStream os, HexCase caseType, String delim) throws IOException {
        Hex.bytesToHexStreaming(is, os, caseType, delim, -1);
    }

    public static void bytesToHexStreaming(Path in, Path out, HexCase caseType, String delim, int maxCharsPerLine, OpenOption ... outOptions) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(in, new OpenOption[0]));
             BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(out, outOptions));){
            Hex.bytesToHexStreaming(is, os, caseType, delim, maxCharsPerLine);
        }
    }

    public static byte hexCharToByte(char c1, char c2) {
        int high = Hex.hexToDec(c1);
        int low = Hex.hexToDec(c2);
        if (high == -1 || low == -1) {
            char illegal = high == -1 ? c1 : c2;
            throw new IllegalArgumentException("Character '" + illegal + "' is illegal. Only characters 0-9, A-F and a-f are allowed.");
        }
        return (byte)(high * 16 + low);
    }

    public static byte[] hexStrToBytes(char[] chars, String delim) {
        if (chars == null) {
            return null;
        }
        return Hex.hexStrToBytes(new String(chars), delim);
    }

    public static byte[] hexStrToBytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        return Hex.hexStrToBytes(new String(chars), null);
    }

    public static byte[] hexStrToBytes(CharSequence s, String delim) {
        int divisor;
        Hex.delimiterCheck(delim);
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return new byte[0];
        }
        int delimLen = delim == null ? 0 : delim.length();
        int numerator = len + delimLen;
        if (numerator % (divisor = 2 + delimLen) != 0) {
            throw new IllegalArgumentException("Hex string \"" + s + "\" is of unexpected length");
        }
        byte[] out = new byte[numerator / divisor];
        int byteCount = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (delimLen > 0 && delim.indexOf(c) >= 0) {
                ++i;
                continue;
            }
            int high = Hex.hexToDec(c);
            int low = Hex.hexToDec(s.charAt(i + 1));
            if (high == -1 || low == -1) {
                int pos = high == -1 ? i : i + 1;
                throw new HexConversionException("Hex string \"" + s + "\" contains illegal character at position " + (pos + 1) + ". Only characters 0-9, A-F and a-f are allowed.");
            }
            out[byteCount] = (byte)(high * 16 + low);
            i += 2;
            ++byteCount;
        }
        return out;
    }

    public static byte[] hexStrToBytes(CharSequence s) {
        return Hex.hexStrToBytes(s, null);
    }

    public static void hexToBytesStreaming(InputStream is, OutputStream os, String delim) throws IOException {
        int b;
        Hex.delimiterCheck(delim);
        byte[] delimBytes = null;
        int delimLen = -1;
        if (delim != null && !delim.isEmpty()) {
            delimBytes = delim.getBytes(StandardCharsets.US_ASCII);
            delimLen = delimBytes.length;
        }
        char c1 = '\u0000';
        char c2 = '\u0000';
        int bytePos = -1;
        int delimPos = -1;
        while ((b = is.read()) != -1) {
            ++bytePos;
            if (b > 127) {
                throw new HexConversionException("Character not belonging to US-ASCII character set was found at byte position " + bytePos);
            }
            if (delimBytes != null && delimPos == -1 && b == delimBytes[0]) {
                if (delimLen <= 1) continue;
                delimPos = 1;
                continue;
            }
            if (delimPos != -1) {
                if (b == delimBytes[delimPos]) {
                    if (delimPos < delimLen - 1) {
                        ++delimPos;
                        continue;
                    }
                    delimPos = -1;
                    continue;
                }
                throw new HexConversionException("Illegal character at position " + bytePos + ". Expected '" + delim.charAt(delimPos) + "'");
            }
            if (b == 10 || b == 13) continue;
            char c = (char)b;
            if (!Hex.isHexChar(c)) {
                throw new HexConversionException("Illegal character at position " + bytePos);
            }
            if (c1 == '\u0000') {
                c1 = c;
                continue;
            }
            c2 = c;
            byte convertedByte = Hex.hexCharToByte(c1, c2);
            os.write(convertedByte);
            c1 = '\u0000';
            c2 = '\u0000';
        }
    }

    public static void hexToBytesStreaming(Path in, Path out, String delim, OpenOption ... outOptions) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(in, new OpenOption[0]));
             BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(out, outOptions));){
            Hex.hexToBytesStreaming(is, os, delim);
        }
    }

    public static boolean isHexStr(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Hex.isHexChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static void delimiterCheck(String delim) {
        if (delim == null || delim.isEmpty()) {
            return;
        }
        for (int i = 0; i < delim.length(); ++i) {
            char c = delim.charAt(i);
            if (Hex.isHexChar(c)) {
                throw new IllegalArgumentException("delim must not contain any of the characters 0-9, A-F or a-f");
            }
            if (Hex.isAsciiPrintableChar(c)) continue;
            throw new IllegalArgumentException("delim must only contain printable ASCII-127 characters");
        }
    }

    private static boolean isAsciiPrintableChar(char c) {
        return c >= ' ' && c < '\u007f';
    }

    private static int hexToDec(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public static enum HexCase {
        LOWER,
        UPPER;

    }
}

