/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.hexutils;

import java.io.PrintStream;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.lbruun.hexutils.Hex;

public class HexDump {
    private HexDump() {
    }

    public static void prettyPrint(byte[] input, Hex.HexCase caseType, int bytesPerLine, int indent, PrintStream ps) {
        HexDump.prettyPrint0(input, caseType, bytesPerLine, indent, (lineNo, lineStr) -> ps.println((String)lineStr));
    }

    public static void prettyPrint(byte[] input, PrintStream ps) {
        HexDump.prettyPrint(input, Hex.HexCase.UPPER, 16, 4, ps);
    }

    public static String[] prettyPrint(byte[] input, Hex.HexCase caseType, int bytesPerLine, int indent) {
        String[] lines = new String[HexDump.getNoOfLines(input.length, bytesPerLine)];
        HexDump.prettyPrint0(input, caseType, bytesPerLine, indent, (lineNo, lineStr) -> {
            lines[lineNo.intValue()] = lineStr;
        });
        return lines;
    }

    public static String[] prettyPrint(byte[] input) {
        return HexDump.prettyPrint(input, Hex.HexCase.UPPER, 16, 4);
    }

    public static String prettyPrintStr(byte[] input, Hex.HexCase caseType, int bytesPerLine, int indent, String lineSeparator) {
        StringBuilder sb = new StringBuilder();
        HexDump.prettyPrint0(input, caseType, bytesPerLine, indent, (lineNo, lineStr) -> {
            sb.append((String)lineStr);
            sb.append(lineSeparator);
        });
        return sb.toString();
    }

    public static String prettyPrintStr(byte[] input, Hex.HexCase caseType, int bytesPerLine, int indent) {
        return HexDump.prettyPrintStr(input, caseType, bytesPerLine, indent, System.lineSeparator());
    }

    public static String prettyPrintStr(byte[] input) {
        return HexDump.prettyPrintStr(input, Hex.HexCase.UPPER, 16, 4, System.lineSeparator());
    }

    private static void prettyPrint0(byte[] input, Hex.HexCase caseType, int bytesPerLine, int indent, BiConsumer<Integer, String> stringConsumer) {
        Objects.requireNonNull(input, "input byte array must not be null");
        if (bytesPerLine < 1) {
            throw new IllegalArgumentException("bytesPerLine must be > 0");
        }
        if (indent < 0) {
            throw new IllegalArgumentException("indent must be >= 0");
        }
        int counterDigits = HexDump.getCounterDigits(input.length);
        int noOfLines = HexDump.getNoOfLines(input.length, bytesPerLine);
        int charsPerLine = indent + counterDigits + 3 + bytesPerLine * 2 + (bytesPerLine - 1) + 3 + bytesPerLine + 1;
        String counterFormatStr = "%0" + counterDigits + "d : ";
        for (int lineNo = 0; lineNo < noOfLines; ++lineNo) {
            String hexDumpLine = HexDump.hexDumpLine(input, caseType, bytesPerLine, indent, charsPerLine, lineNo, counterFormatStr);
            stringConsumer.accept(lineNo, hexDumpLine);
        }
    }

    private static String hexDumpLine(byte[] input, Hex.HexCase caseType, int bytesPerLine, int indent, int charsPerLine, int lineNo, String counterFormatStr) {
        StringBuilder sb = new StringBuilder(charsPerLine);
        for (int x = 0; x < indent; ++x) {
            sb.append(' ');
        }
        sb.append(String.format(counterFormatStr, lineNo * bytesPerLine));
        StringBuilder realChars = new StringBuilder(5 + bytesPerLine);
        realChars.append("  |");
        for (int i = 0; i < bytesPerLine; ++i) {
            char[] charPair;
            int arrayPos = lineNo * bytesPerLine + i;
            if (arrayPos >= input.length) {
                charPair = new char[]{' ', ' '};
                realChars.append(' ');
            } else {
                charPair = Hex.byteToHex(input[arrayPos], caseType);
                realChars.append(HexDump.printable(input[arrayPos]));
            }
            sb.append(charPair[0]);
            sb.append(charPair[1]);
            if (i >= bytesPerLine - 1) continue;
            sb.append(' ');
        }
        realChars.append('|');
        sb.append(realChars.toString());
        return sb.toString();
    }

    private static int getCounterDigits(int inputLen) {
        return Math.max(HexDump.countDigit(inputLen), 4);
    }

    private static int getNoOfLines(int inputLen, int bytesPerLine) {
        return inputLen % bytesPerLine == 0 ? inputLen / bytesPerLine : inputLen / bytesPerLine + 1;
    }

    private static char printable(byte b) {
        char c = (char)b;
        if (c >= ' ' && c <= '~') {
            return c;
        }
        return '.';
    }

    private static int countDigit(int x) {
        return (int)Math.floor(Math.log10(x) + 1.0);
    }
}

