/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.hexutils;

import net.lbruun.hexutils.Hex;

public class HexHarmless {
    public static final String HARMLESS_HEX_REGEXP_CHARCLASS = "[24-9bcdfghkmt]";
    public static final char[] HARMLESS_HEX_CHARS = new char[]{'g', 'h', '2', 'k', '4', '5', '6', '7', '8', '9', 'm', 'b', 'c', 'd', 't', 'f'};

    private HexHarmless() {
    }

    public static char convertFromHarmless(char c) {
        switch (c) {
            case 'g': {
                return '0';
            }
            case 'h': {
                return '1';
            }
            case 'k': {
                return '3';
            }
            case 'm': {
                return 'a';
            }
            case 't': {
                return 'e';
            }
            case '2': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'f': {
                return c;
            }
        }
        throw new IllegalArgumentException("Character '" + c + "' is illegal. Only characters [2,4-9,b,c,d,f,g,h,k.m,t] are allowed.");
    }

    public static char convertToHarmless(char c) {
        switch (c) {
            case '0': {
                return 'g';
            }
            case '1': {
                return 'h';
            }
            case '2': {
                return c;
            }
            case '3': {
                return 'k';
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c;
            }
            case 'a': {
                return 'm';
            }
            case 'b': 
            case 'c': 
            case 'd': {
                return c;
            }
            case 'e': {
                return 't';
            }
            case 'f': {
                return c;
            }
        }
        throw new IllegalArgumentException("Character '" + c + "' is illegal. Only characters [0-9] and [a-f] are allowed.");
    }

    public static char[] convertToHarmless(char[] chars) {
        if (chars == null) {
            return chars;
        }
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = HexHarmless.convertToHarmless(chars[i]);
        }
        return chars;
    }

    public static char[] convertFromHarmless(char[] chars) {
        if (chars == null) {
            return chars;
        }
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = HexHarmless.convertFromHarmless(chars[i]);
        }
        return chars;
    }

    public static char[] byteToHexHarmless(byte b) {
        return HexHarmless.convertToHarmless(Hex.byteToHex(b, Hex.HexCase.LOWER));
    }

    public static char[] bytesToHexHarmless(byte[] bytes) {
        return HexHarmless.convertToHarmless(Hex.bytesToHex(bytes, Hex.HexCase.LOWER, null));
    }

    public static String bytesToHexStrHarmless(byte[] bytes) {
        return new String(HexHarmless.bytesToHexHarmless(bytes));
    }

    public static byte hexCharHarmlessToByte(char c1, char c2) {
        return Hex.hexCharToByte(HexHarmless.convertFromHarmless(c1), HexHarmless.convertFromHarmless(c2));
    }

    public static byte[] hexStrHarmlessToBytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        return Hex.hexStrToBytes(HexHarmless.convertFromHarmless(chars));
    }

    public static byte[] hexStrHarmlessToBytes(CharSequence s) {
        if (s == null) {
            return null;
        }
        char[] chars = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            chars[i] = HexHarmless.convertFromHarmless(s.charAt(i));
        }
        return Hex.hexStrToBytes(chars);
    }
}

