/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.springboot.preliquibase;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import net.lbruun.springboot.preliquibase.PreLiquibaseException;
import net.lbruun.springboot.preliquibase.PreLiquibaseProperties;
import net.lbruun.springboot.preliquibase.utils.LiquibaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StreamUtils;

public class PreLiquibase {
    private static final Logger logger = LoggerFactory.getLogger(PreLiquibase.class);
    private final DataSource dataSource;
    private final PreLiquibaseProperties properties;
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private List<Resource> unfilteredResources;
    private List<Resource> filteredResources;
    private String dbPlatformCode;
    private boolean hasExecutedScripts;
    private volatile boolean hasExecuted = false;

    public PreLiquibase(Environment environment, DataSource dataSource, PreLiquibaseProperties properties, ResourceLoader resourceLoader) {
        this.environment = environment;
        this.dataSource = dataSource;
        this.properties = properties;
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader(null);
    }

    public synchronized void execute() {
        if (!this.hasExecuted) {
            this.hasExecuted = true;
            this.dbPlatformCode = this.resolveDbPlatformCode();
            this.unfilteredResources = this.getScripts(this.properties.getSqlScriptReferences());
            this.filteredResources = this.getFilteredResources(this.unfilteredResources);
            this.hasExecutedScripts = this.executeSQLScripts();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<Resource> getUnfilteredResources() {
        if (!this.hasExecuted) {
            throw PreLiquibaseException.UninitializedError.DEFAULT;
        }
        return this.unfilteredResources;
    }

    public List<Resource> getFilteredResources() {
        if (!this.hasExecuted) {
            throw PreLiquibaseException.UninitializedError.DEFAULT;
        }
        return this.filteredResources;
    }

    public String getDbPlatformCode() {
        if (!this.hasExecuted) {
            throw PreLiquibaseException.UninitializedError.DEFAULT;
        }
        return this.dbPlatformCode;
    }

    public boolean hasExecutedScripts() {
        if (!this.hasExecuted) {
            throw PreLiquibaseException.UninitializedError.DEFAULT;
        }
        return this.hasExecutedScripts;
    }

    private boolean executeSQLScripts() {
        if (!this.properties.isEnabled()) {
            logger.debug("Initialization disabled (not running SQL script)");
            return false;
        }
        if (!this.filteredResources.isEmpty()) {
            this.runScripts();
            return true;
        }
        logger.debug("Pre-Liquibase disabled (no SQL script found)");
        return false;
    }

    private String getDbPlatformCodeFromDataSource() throws PreLiquibaseException.ResolveDbPlatformError {
        logger.debug("Determining db platform from DataSource");
        String dbPlatformCodeCandidate = LiquibaseUtils.getLiquibaseDatabaseShortName(this.dataSource);
        logger.debug("Determined database platform as '" + dbPlatformCodeCandidate + "'");
        return dbPlatformCodeCandidate;
    }

    private String resolveDbPlatformCode() {
        String dbPlatformCodeFromProps = this.properties.getDbPlatformCode();
        return dbPlatformCodeFromProps == null ? this.getDbPlatformCodeFromDataSource() : dbPlatformCodeFromProps;
    }

    private List<Resource> getScripts(List<String> resources) {
        if (resources.size() == 1 && (resources.get(0).endsWith("/") || resources.get(0).endsWith("\\"))) {
            String pathLoc = resources.get(0);
            ArrayList<String> absSqlFileLocations = new ArrayList<String>();
            absSqlFileLocations.add(pathLoc + this.dbPlatformCode + ".sql");
            absSqlFileLocations.add(pathLoc + "default.sql");
            return this.getResourcesFromStringLocations(absSqlFileLocations, false, true);
        }
        return this.getResourcesFromStringLocations(resources, true, false);
    }

    private List<Resource> getResourcesFromStringLocations(List<String> locations, boolean validateExistence, boolean onlyUseFirstScript) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            for (Resource resource : this.doGetResources(location)) {
                if (resource.exists()) {
                    resources.add(resource);
                    if (!onlyUseFirstScript) continue;
                    return resources;
                }
                if (!validateExistence) continue;
                String msg = "Resource \"" + location + "\" is invalid or cannot be found";
                throw new PreLiquibaseException.SqlScriptRefError(msg);
            }
        }
        return resources;
    }

    private Resource[] doGetResources(String location) {
        try {
            SortedResourcesFactoryBean factory = new SortedResourcesFactoryBean(this.resourceLoader, Collections.singletonList(location));
            factory.afterPropertiesSet();
            return (Resource[])factory.getObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error when creating Resource object from \"" + location + "\"", ex);
        }
    }

    private List<Resource> getFilteredResources(List<Resource> resources) {
        if (resources == null || resources.isEmpty() || this.environment == null) {
            return resources;
        }
        Map<String, String> defaultsMapping = Stream.of(new String[][]{{"spring.liquibase.liquibase-schema", "spring.liquibase.default-schema"}}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
        PreLiquibasePlaceholderResolver preLiquibasePlaceholderResolver = new PreLiquibasePlaceholderResolver(this.environment, defaultsMapping);
        PropertyPlaceholderHelper placeholderReplacer = new PropertyPlaceholderHelper("${", "}", ":", false);
        ArrayList<Resource> newList = new ArrayList<Resource>(resources.size());
        for (Resource resource : resources) {
            try {
                InputStream in = resource.getInputStream();
                try {
                    String txt = StreamUtils.copyToString((InputStream)in, (Charset)this.properties.getSqlScriptEncoding());
                    String filteredTxt = placeholderReplacer.replacePlaceholders(txt, (PropertyPlaceholderHelper.PlaceholderResolver)preLiquibasePlaceholderResolver);
                    if (!filteredTxt.equals(txt)) {
                        logger.debug("SQL script " + resource + " before replacement variable substitution : " + txt);
                        logger.debug("SQL script " + resource + " after replacement variable substitution : " + filteredTxt);
                    } else {
                        logger.debug("No replacement variables are in " + resource + ". Using the SQL script as-is.");
                    }
                    newList.add(new StringShadowResource(filteredTxt, resource, this.properties.getSqlScriptEncoding()));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new PreLiquibaseException.SqlScriptReadError("Could not read SQL script file \"" + resource + " into memory", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new PreLiquibaseException.SqlScriptVarError("Could not replace variables in script file \"" + resource + "\"", ex);
            }
        }
        return newList;
    }

    private void runScripts() throws ScriptException {
        List<Resource> resources = this.filteredResources;
        if (resources.isEmpty()) {
            return;
        }
        if (resources.size() > 1) {
            logger.info("PreLiquibase: Executing SQL scripts : " + resources.toString());
        } else {
            logger.info("PreLiquibase: Executing SQL script : " + resources.get(0).toString());
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(this.properties.isContinueOnError());
        populator.setSeparator(this.properties.getSeparator());
        if (this.properties.getSqlScriptEncoding() != null) {
            populator.setSqlScriptEncoding(this.properties.getSqlScriptEncoding().name());
        }
        resources.forEach(resource -> populator.addScript(resource));
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
    }

    private static class PreLiquibasePlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Environment environment;
        private final Map<String, String> defaults;

        public PreLiquibasePlaceholderResolver(Environment environment, Map<String, String> defaults) {
            this.environment = environment;
            this.defaults = defaults;
        }

        public String resolvePlaceholder(String placeholderName) {
            if (this.environment == null) {
                return null;
            }
            String val = this.environment.getProperty(placeholderName);
            if (val == null && this.defaults != null && this.defaults.containsKey(placeholderName)) {
                val = this.environment.getProperty(this.defaults.get(placeholderName));
            }
            return val;
        }
    }

    static class StringShadowResource
    implements Resource {
        private final String content;
        private final Resource originalResource;
        private final Charset encoding;

        public StringShadowResource(String content, Resource originalResource, Charset encoding) {
            this.content = content;
            this.originalResource = originalResource;
            this.encoding = encoding;
        }

        public boolean exists() {
            return true;
        }

        public URL getURL() throws IOException {
            return this.originalResource.getURL();
        }

        public URI getURI() throws IOException {
            return this.originalResource.getURI();
        }

        public File getFile() throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public long contentLength() throws IOException {
            return this.content.getBytes(this.encoding).length;
        }

        public long lastModified() throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Resource createRelative(String relativePath) throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getFilename() {
            return this.originalResource.getFilename();
        }

        public String getDescription() {
            return this.originalResource.getDescription();
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes(this.encoding));
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

