/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.springboot.preliquibase;

import java.util.Objects;
import javax.sql.DataSource;
import liquibase.change.DatabaseChange;
import liquibase.integration.spring.SpringLiquibase;
import net.lbruun.springboot.preliquibase.PreLiquibase;
import net.lbruun.springboot.preliquibase.PreLiquibaseDataSourceProvider;
import net.lbruun.springboot.preliquibase.PreLiquibaseProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseConnectionDetails;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={DataSourceAutoConfiguration.class}, before={LiquibaseAutoConfiguration.class})
@ConditionalOnClass(value={SpringLiquibase.class, DatabaseChange.class})
@Conditional(value={LiquibaseDataSourceCondition.class, EnabledCondition.class})
@ConditionalOnMissingBean(value={SpringLiquibase.class, PreLiquibase.class})
@EnableConfigurationProperties(value={DataSourceProperties.class, LiquibaseProperties.class, PreLiquibaseProperties.class})
public class PreLiquibaseAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(PreLiquibaseAutoConfiguration.class);

    @ConditionalOnMissingBean(value={PreLiquibaseDataSourceProvider.class})
    @Bean
    public PreLiquibaseDataSourceProvider preLiquibaseDataSourceProvider(ObjectProvider<DataSource> dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource, LiquibaseConnectionDetails connectionDetails) {
        this.logger.debug("Instantiation of PreLiquibaseDataSourceProvider");
        return new DefaultPreLiquibaseDataSourceProvider(dataSource, liquibaseDataSource, connectionDetails);
    }

    @Bean
    public PreLiquibase preLiquibase(Environment environment, PreLiquibaseProperties properties, PreLiquibaseDataSourceProvider dataSourceProvider, ApplicationContext applicationContext) {
        this.logger.debug("Instantiation of PreLiquibase");
        PreLiquibase preLiquibase = new PreLiquibase(environment, dataSourceProvider.getDataSource(), properties, (ResourceLoader)applicationContext);
        preLiquibase.execute();
        return preLiquibase;
    }

    static class DefaultPreLiquibaseDataSourceProvider
    implements PreLiquibaseDataSourceProvider {
        private final DataSource dataSourceToUse;

        public DefaultPreLiquibaseDataSourceProvider(@NonNull ObjectProvider<DataSource> dataSource, @NonNull ObjectProvider<DataSource> liquibaseDataSource, @NonNull LiquibaseConnectionDetails connectionDetails) {
            this.dataSourceToUse = this.getMigrationDataSource((DataSource)liquibaseDataSource.getIfAvailable(), (DataSource)dataSource.getIfAvailable(), connectionDetails);
            Objects.requireNonNull(this.dataSourceToUse, "Unexpected: null value for DataSource returned from SpringLiquibase class");
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSourceToUse;
        }

        private DataSource getMigrationDataSource(DataSource liquibaseDataSource, DataSource dataSource, LiquibaseConnectionDetails connectionDetails) {
            if (liquibaseDataSource != null) {
                return liquibaseDataSource;
            }
            String url = connectionDetails.getJdbcUrl();
            if (url != null) {
                DataSourceBuilder builder = DataSourceBuilder.create().type(SimpleDriverDataSource.class);
                builder.url(url);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            String user = connectionDetails.getUsername();
            if (user != null && dataSource != null) {
                DataSourceBuilder builder = DataSourceBuilder.derivedFrom((DataSource)dataSource).type(SimpleDriverDataSource.class);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            Assert.state((dataSource != null ? 1 : 0) != 0, (String)"Liquibase migration DataSource missing");
            return dataSource;
        }

        private void applyConnectionDetails(LiquibaseConnectionDetails connectionDetails, DataSourceBuilder<?> builder) {
            builder.username(connectionDetails.getUsername());
            builder.password(connectionDetails.getPassword());
            String driverClassName = connectionDetails.getDriverClassName();
            if (StringUtils.hasText((String)driverClassName)) {
                builder.driverClassName(driverClassName);
            }
        }
    }

    static final class EnabledCondition
    extends AllNestedConditions {
        EnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, matchIfMissing=true)
        private static final class liquibaseEnabledCondition {
            private liquibaseEnabledCondition() {
            }
        }

        @ConditionalOnProperty(prefix="preliquibase", name={"enabled"}, matchIfMissing=true)
        private static final class preLiquibaseEnabledCondition {
            private preLiquibaseEnabledCondition() {
            }
        }
    }

    static final class LiquibaseDataSourceCondition
    extends AnyNestedCondition {
        LiquibaseDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.liquibase", name={"url"}, matchIfMissing=false)
        private static final class LiquibaseUrlCondition {
            private LiquibaseUrlCondition() {
            }
        }

        @ConditionalOnBean(value={JdbcConnectionDetails.class})
        private static final class JdbcConnectionDetailsCondition {
            private JdbcConnectionDetailsCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringLiquibase.class})
    static class LiquibaseOnPreLiquibaseDependencyPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        Logger logger = LoggerFactory.getLogger(LiquibaseOnPreLiquibaseDependencyPostProcessor.class);

        LiquibaseOnPreLiquibaseDependencyPostProcessor() {
            super(SpringLiquibase.class, new Class[]{PreLiquibase.class});
            this.logger.debug("Downstream dependencies on PreLiquibase are now configured");
        }
    }
}

