package net.leadware.velocity.maven.plugin.mojo;

/*
 * #%L
 * Velocity Maven Plugin Mojo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2016 Leadware
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import org.apache.maven.plugin.AbstractMojo;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

/**
 * Classe representant un gestionnaire de log
 * @author <a href="mailto:jetune@leadware.net">Jean-Jacques ETUNE NGI (Leadware Enterprise Architect)</a>
 * @since 18 févr. 2016 - 07:56:58
 */
public class LogHandler implements LogChute {
	
	// MOJO en cours
	private AbstractMojo mojo;
	
	/**
	 * Constructeur avec initialisation de parametres
	 * @param mojo	MOJO en cours
	 */
	public LogHandler( AbstractMojo mojo ) {
		
		// Positionnement du MOJO
		this.mojo = mojo;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.apache.velocity.runtime.log.LogChute#isLevelEnabled(int)
	 */
	public boolean isLevelEnabled(int level) {
		
		// Etat d'activation
		boolean enabled = false;
		
		// Si le niveau est debug et Debug est active sur le MOJO
		if (level == DEBUG_ID && mojo.getLog().isDebugEnabled()) enabled = true;
		
		// Si le niveau est INFO et INFO est activé sur le MOJO
		else if (level == INFO_ID && mojo.getLog().isInfoEnabled()) enabled = true;
		
		// Si le niveau est WARNING et WARNING est activé sur le MOJO
		else if (level == WARN_ID && mojo.getLog().isWarnEnabled()) enabled = true;
		
		// Si le niveau est ERROR et ERROR est activé sur le MOJO
		else if (level == ERROR_ID && mojo.getLog().isErrorEnabled()) enabled = true;
		
		// On retourne l'etat d'activation
		return enabled;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.apache.velocity.runtime.log.LogChute#log(int, java.lang.String)
	 */
	public void log(int level, String content) {
		
		// Si le niveau demande est active
		if (isLevelEnabled(level))
			
			// Choix sur le niveau
			switch (level) {
				
				// Si le niveau est Debug
				case DEBUG_ID :
					
					// On Log en debug
					mojo.getLog().debug(content);
					
					// On sort
					break;
				
					// Si le niveau est INFO
				case INFO_ID :
					
					// On log en INFO
					mojo.getLog().info(content);
					
					// On sort
					break;
					
				// Si le niveau est WARNING
				case WARN_ID :
					
					// On log en warn
					mojo.getLog().warn(content);
					
					// On sort
					break;
					
				// Si le niveau est ERROR
				case ERROR_ID :
					
					// On log en Error
					mojo.getLog().error(content);
					
					// On sort
					break;
				
				// Sinon on fait rien
				default:
			}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.apache.velocity.runtime.log.LogChute#log(int, java.lang.String, java.lang.Throwable)
	 */
	public void log(int level, String content, Throwable throwable) {
		
		// Si le niveau demande est active
		if (isLevelEnabled(level))
			
			// Choix sur le niveau
			switch (level) {
				
				// Si le niveau est Debug
				case DEBUG_ID :
					
					// On Log en debug
					mojo.getLog().debug(content, throwable);
					
					// On sort
					break;
				
					// Si le niveau est INFO
				case INFO_ID :
					
					// On log en INFO
					mojo.getLog().info(content, throwable);
					
					// On sort
					break;
					
				// Si le niveau est WARNING
				case WARN_ID :
					
					// On log en warn
					mojo.getLog().warn(content, throwable);
					
					// On sort
					break;
					
				// Si le niveau est ERROR
				case ERROR_ID :
					
					// On log en Error
					mojo.getLog().error(content, throwable);
					
					// On sort
					break;
				
				// Sinon on fait rien
				default:
			}
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.velocity.runtime.log.LogChute#init(org.apache.velocity.runtime.RuntimeServices)
	 */
	public void init(RuntimeServices runtimeServices) throws Exception {}
}
