package net.leanix.dropkit.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import javax.ws.rs.client.WebTarget;

/**
 * Api client.
 *
 *
 */
public class Client {

    private final String baseUrl;
    private final javax.ws.rs.client.Client apiClient;

    /**
     * Constructor
     *
     * @param baseUrl the api base url
     * @param apiClient a preconfigured client (except auth)
     */
    public Client(
            String baseUrl,
            javax.ws.rs.client.Client apiClient
    ) {
        this.baseUrl = baseUrl;
        this.apiClient = apiClient;
    }

    public WebTarget resource(String path) {
        return apiClient.target(getUrl(path));
    }

    /**
     * Returns the base url plus the path.
     *
     * @param path
     * @return
     */
    public String getUrl(String path) {
        return baseUrl + path;
    }

    /**
     * Serializes the object to string and computes the hash code.
     *
     * In the case of Strings the hash code can be used as checksum.
     *
     * @param o
     * @return
     * @throws JsonProcessingException
     */
    private int getObjectStringHash(Object o) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(o).hashCode();
    }
}
