package net.leanix.dropkit.oauth;

import java.io.IOException;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.HttpHeaders;

/**
 * Adds oauth access token to requests.
 *
 *
 */
public class ClientCredentialsApiAuthFilter implements ClientRequestFilter {

    /**
     * Constant for the access token (oauth2 spec).
     */
    private static final String BEARER = "Bearer";

    /**
     * The factory that calls the oauth auth server when a token is needed.
     */
    private final ClientCredentialAccessTokenFactory accessTokenFactory;

    /**
     * Constructor.
     *
     * @param accessTokenFactory inject the access token factory
     */
    public ClientCredentialsApiAuthFilter(ClientCredentialAccessTokenFactory accessTokenFactory) {
        this.accessTokenFactory = accessTokenFactory;
    }

    @Override
    public void filter(ClientRequestContext cr) throws IOException {
        String accessToken;
        try {
            accessToken = accessTokenFactory.getAccessToken();
        } catch (FlowException ex) {
            throw new IOException("Failed to attach bearer token", ex);
        }

        cr.getHeaders().remove(HttpHeaders.AUTHORIZATION);
        cr.getHeaders().add(HttpHeaders.AUTHORIZATION, BEARER + " " + accessToken);
    }

}
