package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

import java.security.Key;

/**
 * Configuration for oauth resource providers.
 *
 *
 */
public class OAuth2ClientConfig implements OAuth2TokenConfig {

    private String baseUrl;

    private String tokenUrl;

    /**
     * Oauth auth server url.
     */
    @JsonProperty
    private String introspectionUrl;

    /**
     * The key/identifier of the resource server.
     */
    @JsonProperty
    private String clientId;

    /**
     * The shared secret of the resource server.
     */
    @JsonProperty
    private String clientSecret;

    /**
     * The path to the public key for token verification
     */
    @JsonProperty
    private String publicKeyPath;

    public String getIntrospectionUrl() {
        return introspectionUrl;
    }

    public void setIntrospectionUrl(String introspectionUrl) {
        this.introspectionUrl = introspectionUrl;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getTokenUrl() {
        return tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getPublicKeyPath() {
        return publicKeyPath;
    }

    public void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws Exception {
        if (this.publicKeyPath == null)
            throw new Exception("SigningKeyPath must be set");

        return KeyReaderRSA.getPublicKey(this.publicKeyPath);
    }
}
