package net.leanix.dropkit.oauth.models;

import java.io.Serializable;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

/**
 * Account representation
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account implements Serializable {

    private static final long serialVersionUID = 1L;

    private UUID id;

    private String name;

    public Account() {
        this.id = null;
        this.name = null;
    }

    public Account(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    @JsonProperty
    @ApiModelProperty(dataType = "string")
    public UUID getId() {
        return id;
    }

    @JsonProperty
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(UUID id) {
        this.id = id;
    }
}
