package net.leanix.dropkit.oauth.token;

import java.security.Key;
import java.util.Date;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

public class OAuth2TokenCreator {
    /**
     * Token can be refreshed 8 hours after it expired
     */
    private static int DEFAULT_REFRESH_DURATION = 8 * 60 * 60;

    OAuth2TokenConfig config;
    Key key;

    public OAuth2TokenCreator(OAuth2TokenConfig config) throws Exception {
        this.config = config;
        this.key = config.getSigningKey();
    }

    /**
     * Creates a token and returns it as String
     *
     * @param token
     * @return
     */
    public String create(OAuth2Token token) throws Exception {
        if (token.getExpiration() == null)
            throw new Exception("Expiration must not be null when creating new oauth2 token");

        JwtBuilder builder = Jwts.builder()
                .setSubject(token.getPrincipal().getUsername())
                .claim("principal", token.getPrincipal())
                .setExpiration(token.getExpiration());

        if (token.getRefreshToken() != null) {
            builder.claim("refresh_token", token.getRefreshToken());

            if (token.getRefreshExpiration() != null) {
                builder.claim("refresh_exp", token.getRefreshExpiration());
            } else {
                Date refreshExp = new Date((token.getExpiration().getTime() / 1000L) + DEFAULT_REFRESH_DURATION);
                builder.claim("refresh_exp", refreshExp);
            }
        }

        return builder.signWith(SignatureAlgorithm.RS256, this.key).compact();
    }
}
