/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.net.URI;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import net.leanix.dropkit.api.Client;
import net.leanix.dropkit.oauth.ClientCredentialAccessTokenFactory;
import net.leanix.dropkit.oauth.ClientCredentialsApiAuthFilter;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;

public class ClientFactory {
    public static Client create(OAuth2ClientConfig config) {
        return ClientFactory.create(config, false);
    }

    public static Client create(OAuth2ClientConfig config, boolean enableHttpLogging) {
        URI tokenURI = URI.create(config.getTokenUrl());
        ClientConfig cc = new ClientConfig();
        cc.property("jersey.config.client.followRedirects", (Object)Boolean.TRUE);
        if (enableHttpLogging) {
            cc.register(LoggingFilter.class);
        }
        cc.register((Object)ClientFactory.getAuthFilter(ClientCredentialAccessTokenFactory.create(config)));
        cc.register(JacksonJsonProvider.class);
        javax.ws.rs.client.Client c = ClientBuilder.newClient((Configuration)cc);
        return new Client(config.getBaseUrl(), c);
    }

    public static Client create(String baseUrl, String tokenUrl, String verificationUrl, String clientId, String clientSecret) {
        return ClientFactory.create(baseUrl, tokenUrl, verificationUrl, clientId, clientSecret, false);
    }

    public static Client create(String baseUrl, String tokenUrl, String introspectionUrl, String clientId, String clientSecret, boolean enableHttpLogging) {
        OAuth2ClientConfig config = new OAuth2ClientConfig();
        config.setBaseUrl(baseUrl);
        config.setTokenUrl(tokenUrl);
        config.setIntrospectionUrl(introspectionUrl);
        config.setClientId(clientId);
        config.setClientSecret(clientSecret);
        return ClientFactory.create(config, enableHttpLogging);
    }

    public static Client create(String baseUrl) {
        javax.ws.rs.client.Client c = ClientFactory.createJerseyClientWithJacksonSerializer();
        return new Client(baseUrl, c);
    }

    public static javax.ws.rs.client.Client createJerseyClientWithJacksonSerializer() {
        ClientConfig cc = new ClientConfig();
        cc.property("jersey.config.client.followRedirects", (Object)true);
        cc.register(JacksonJsonProvider.class);
        return ClientBuilder.newClient((Configuration)cc);
    }

    private static ClientCredentialsApiAuthFilter getAuthFilter(ClientCredentialAccessTokenFactory factory) {
        return new ClientCredentialsApiAuthFilter(factory);
    }
}

