/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import java.nio.charset.Charset;
import java.util.Base64;
import javax.ws.rs.client.Client;
import net.leanix.dropkit.api.ClientFactory;
import net.leanix.dropkit.oauth.FlowException;
import net.leanix.dropkit.oauth.OAuth2ClientConfig;
import net.leanix.dropkit.oauth.responses.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialAccessTokenFactory {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final OAuth2ClientConfig config;
    private final String authorization;
    private final Client apiClient;
    private final Logger logger = LoggerFactory.getLogger(ClientCredentialAccessTokenFactory.class);
    private AccessTokenResponse accessTokenResponse;

    public static ClientCredentialAccessTokenFactory create(OAuth2ClientConfig config) {
        Client apiClient = ClientFactory.createJerseyClientWithJacksonSerializer();
        return new ClientCredentialAccessTokenFactory(config, apiClient);
    }

    public ClientCredentialAccessTokenFactory(OAuth2ClientConfig config, Client apiClient) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(config.getClientId()).append(':').append(config.getClientSecret());
        String userAndPw = sb.toString();
        sb.setLength(0);
        sb.append("Basic ").append(Base64.getEncoder().encodeToString(userAndPw.getBytes(UTF8)));
        this.authorization = sb.toString();
        this.config = config;
        this.apiClient = apiClient;
    }

    public String getAccessToken() throws FlowException {
        if (this.accessTokenResponse == null) {
            this.fetchToken();
        } else if (this.accessTokenResponse.isExpired()) {
            this.fetchToken();
        }
        return this.accessTokenResponse.getAccessToken();
    }

    private void fetchToken() throws FlowException {
        try {
            this.accessTokenResponse = (AccessTokenResponse)this.apiClient.target(this.config.getTokenUrl().concat("?grant_type=client_credentials")).request(new String[]{"application/json"}).header("Content-Type", (Object)"application/json").header("Authorization", (Object)this.authorization).post(null, AccessTokenResponse.class);
        }
        catch (RuntimeException ex) {
            this.throwFlowException("Failed to retrieve a new oauth token from " + this.config.getTokenUrl() + " using " + this.authorization, ex);
        }
    }

    private void throwFlowException(String message, Exception ex) throws FlowException {
        this.logger.error(message, (Throwable)ex);
        throw new FlowException(message);
    }
}

