/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.UUID;
import net.leanix.dropkit.oauth.models.Account;
import net.leanix.dropkit.oauth.models.Permission;
import net.leanix.dropkit.oauth.models.PermissionRole;
import net.leanix.dropkit.oauth.models.Principal;
import net.leanix.dropkit.oauth.models.UserRole;
import net.leanix.dropkit.oauth.models.UserStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
implements Serializable,
Principal {
    private static final long serialVersionUID = 1L;
    private UUID id = null;
    private String username = null;
    private UserRole role;
    private UserStatus status;
    private Account account;
    private Permission permission;
    @JsonIgnore
    private String accessToken;

    @Override
    @ApiModelProperty(dataType="string")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public boolean hasPermission(UUID workspaceId, PermissionRole role) {
        if (this.permission != null) {
            return this.permission.isActive() && this.permission.getWorkspaceId().equals(workspaceId) && this.permission.hasRole(role);
        }
        return false;
    }

    @Override
    public boolean hasPermission(UUID workspaceId) {
        if (this.permission != null) {
            return this.permission.isActive() && this.permission.getWorkspaceId().equals(workspaceId);
        }
        return false;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Override
    @ApiModelProperty(dataType="string")
    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    @Override
    @ApiModelProperty(dataType="string")
    public UserStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    @Override
    @JsonIgnore
    public boolean isActive(UserRole role) {
        return this.getRole() != null && this.getRole().equals((Object)role) && UserStatus.ACTIVE.equals((Object)this.status);
    }

    @Override
    @JsonIgnore
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonIgnore
    public void setAccessToken(String token) {
        this.accessToken = token;
    }
}

