/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessTokenResponse {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    private String scope;
    private static int LEAD_TIME = 60;
    @JsonIgnore
    private Date expires;

    public AccessTokenResponse() {
    }

    public AccessTokenResponse(String accessToken, String tokenType, long expiresIn, String refreshToken, String scope) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.refreshToken = refreshToken;
        this.scope = scope;
        this.calcExpires();
    }

    public void calcExpires() {
        this.expires = new Date(System.currentTimeMillis() + this.expiresIn * 1000L);
    }

    public Date getExpires() {
        return this.expires;
    }

    public boolean isExpired() {
        return this.expires.getTime() - (long)(LEAD_TIME * 1000) < System.currentTimeMillis();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
        this.calcExpires();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String toString() {
        return "AccessTokenResponse [accessToken=" + this.accessToken + ", tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ", refreshToken=" + this.refreshToken + ", scope=" + this.scope + "]";
    }
}

