/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.token;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2TokenCreator {
    private static int DEFAULT_REFRESH_DURATION = 28800;
    OAuth2TokenConfig config;
    Key key;

    public OAuth2TokenCreator(OAuth2TokenConfig config) throws Exception {
        this.config = config;
        this.key = config.getSigningKey();
    }

    public String create(OAuth2Token token) throws Exception {
        if (token.getExpiration() == null) {
            throw new Exception("Expiration must not be null when creating new oauth2 token");
        }
        JwtBuilder builder = Jwts.builder().setSubject(token.getPrincipal().getUsername()).claim("principal", (Object)token.getPrincipal()).setExpiration(token.getExpiration());
        if (token.getRefreshToken() != null) {
            builder.claim("refresh_token", (Object)token.getRefreshToken());
            if (token.getRefreshExpiration() != null) {
                builder.claim("refresh_exp", (Object)token.getRefreshExpiration());
            } else {
                Date refreshExp = new Date(token.getExpiration().getTime() / 1000L + (long)DEFAULT_REFRESH_DURATION);
                builder.claim("refresh_exp", (Object)refreshExp);
            }
        }
        return builder.signWith(SignatureAlgorithm.RS256, this.key).compact();
    }
}

