/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.deflate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.LimitWriteOperations;
import net.lecousin.framework.memory.ByteArrayCache;

public class DeflateCompressor {
    private int level;
    private boolean nowrap;
    private static final String TASK_NAME = "Zip compression";

    public DeflateCompressor(int level, boolean nowrap) {
        this.level = level;
        this.nowrap = nowrap;
    }

    public DeflateCompressor(boolean nowrap) {
        this(9, nowrap);
    }

    public DeflateCompressor() {
        this(9, false);
    }

    public IAsync<Exception> compress(IO.Readable input, IO.Writable output, int bufferSize, int maxBuffers, Task.Priority priority) {
        Deflater deflater = new Deflater(this.level, this.nowrap);
        ByteArrayCache cache = ByteArrayCache.getInstance();
        LimitWriteOperations limit = new LimitWriteOperations(output, maxBuffers, buf -> cache.free((Object)buf.array()));
        byte[] bufRead = (byte[])cache.get(bufferSize, false);
        ByteBuffer buffer = ByteBuffer.wrap(bufRead);
        AsyncSupplier task = input.readAsync(buffer);
        Async end = new Async();
        Task compress = Task.cpu((String)TASK_NAME, (Task.Priority)priority, (Executable)new Compress(input, output, task, bufRead, cache, bufferSize, deflater, limit, end));
        end.onCancel(arg_0 -> ((Task)compress).cancel(arg_0));
        task.thenStart(compress, true);
        return end;
    }

    private static class Compress
    implements Executable<Void, Exception> {
        private IO.Readable input;
        private IO.Writable output;
        private AsyncSupplier<Integer, IOException> readTask;
        private ByteArrayCache cache;
        private int bufferSize;
        private byte[] readBuf;
        private Deflater deflater;
        private LimitWriteOperations limit;
        private Async<Exception> end;

        private Compress(IO.Readable input, IO.Writable output, AsyncSupplier<Integer, IOException> readTask, byte[] readBuf, ByteArrayCache cache, int bufferSize, Deflater delfater, LimitWriteOperations limit, Async<Exception> end) {
            this.input = input;
            this.output = output;
            this.readTask = readTask;
            this.cache = cache;
            this.bufferSize = bufferSize;
            this.readBuf = readBuf;
            this.deflater = delfater;
            this.limit = limit;
            this.end = end;
            end.onCancel(arg_0 -> readTask.cancel(arg_0));
        }

        public Void execute(Task<Void, Exception> taskContext) throws Exception {
            if (this.readTask.isCancelled() || this.end.isCancelled()) {
                return null;
            }
            if (!this.readTask.isSuccessful()) {
                this.end.error(this.readTask.getError());
                throw (IOException)this.readTask.getError();
            }
            try {
                this.compress(taskContext);
            }
            catch (Exception e) {
                this.end.error(e);
                throw e;
            }
            return null;
        }

        private void compress(Task<Void, Exception> taskContext) throws IOException, CancelException {
            int nb = (Integer)this.readTask.getResult();
            CompressStatus status = new CompressStatus(0, ByteBuffer.wrap((byte[])this.cache.get(this.bufferSize, false)));
            if (nb <= 0) {
                this.deflater.finish();
                while (!this.deflater.finished() && !this.compressLoop(status, taskContext)) {
                }
                this.deflater.end();
                this.deflater = null;
            } else {
                this.deflater.setInput(this.readBuf, 0, nb);
                while (!(this.deflater.needsInput() || this.end.isCancelled() || this.compressLoop(status, taskContext))) {
                }
            }
            if (this.end.isCancelled()) {
                return;
            }
            if (this.deflater != null && !this.deflater.finished()) {
                this.writeAndContinue(status);
            } else {
                this.writeAndEnd(status);
            }
        }

        private boolean compressLoop(CompressStatus status, Task<Void, Exception> taskContext) throws IOException, CancelException {
            int nb;
            if (taskContext.isCancelling()) {
                throw taskContext.getCancelEvent();
            }
            if (status.writeBuf == null) {
                status.writeBuf = ByteBuffer.wrap((byte[])this.cache.get(this.bufferSize, false));
            }
            if ((nb = this.deflater.deflate(status.writeBuf.array(), status.pos, status.writeBuf.capacity() - status.pos)) <= 0) {
                return true;
            }
            CompressStatus compressStatus = status;
            compressStatus.pos = compressStatus.pos + nb;
            if (status.pos == status.writeBuf.capacity()) {
                this.writeCompressedData(status);
                status.pos = 0;
                status.writeBuf = null;
            }
            return false;
        }

        private void writeAndContinue(CompressStatus status) throws IOException {
            if (status.pos > 0) {
                this.writeCompressedData(status);
            } else if (status.writeBuf != null) {
                this.cache.free((Object)status.writeBuf.array());
            }
            AsyncSupplier task = this.input.readAsync(ByteBuffer.wrap(this.readBuf));
            Task compress = Task.cpu((String)DeflateCompressor.TASK_NAME, (Executable)new Compress(this.input, this.output, (AsyncSupplier<Integer, IOException>)task, this.readBuf, this.cache, this.bufferSize, this.deflater, this.limit, this.end));
            this.end.onCancel(arg_0 -> ((Task)compress).cancel(arg_0));
            task.thenStart(compress, true);
        }

        private void writeAndEnd(CompressStatus status) throws IOException {
            AsyncSupplier write = null;
            if (status.pos > 0) {
                write = this.writeCompressedData(status);
            } else {
                if (status.writeBuf != null) {
                    this.cache.free((Object)status.writeBuf.array());
                }
                write = this.limit.getLastPendingOperation();
            }
            if (write == null) {
                this.end.unblock();
            } else {
                write.onDone(this.end, e -> e);
            }
        }

        private AsyncSupplier<Integer, IOException> writeCompressedData(CompressStatus status) throws IOException {
            status.writeBuf.limit(status.pos);
            status.writeBuf.position(0);
            AsyncSupplier res = this.limit.write((Object)status.writeBuf);
            if (res.hasError()) {
                throw (IOException)res.getError();
            }
            return res;
        }

        private static class CompressStatus {
            private int pos;
            private ByteBuffer writeBuf;

            private CompressStatus(int pos, ByteBuffer writeBuf) {
                this.pos = pos;
                this.writeBuf = writeBuf;
            }
        }
    }
}

