/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.deflate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class DeflateReadable
extends ConcurrentCloseable<IOException>
implements IO.Readable {
    private IO.Readable input;
    private Task.Priority priority;
    private Inflater inflater;
    private ByteBuffer readBuf;
    private boolean reachEOF = false;
    private static final String ERROR_CLOSED = "Deflate stream closed";

    public DeflateReadable(IO.Readable input, Task.Priority priority, boolean nowrap, int bufferSize) {
        this.inflater = new Inflater(nowrap);
        this.input = input;
        this.priority = priority;
        this.readBuf = ByteBuffer.wrap((byte[])ByteArrayCache.getInstance().get(bufferSize, true));
    }

    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    public Task.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Task.Priority priority) {
        this.priority = priority;
    }

    public String getSourceDescription() {
        return "Deflate stream: " + (this.input != null ? this.input.getSourceDescription() : "closed");
    }

    public IO getWrappedIO() {
        return null;
    }

    protected IAsync<IOException> closeUnderlyingResources() {
        return this.input.closeAsync();
    }

    protected void closeResources(Async<IOException> ondone) {
        this.input = null;
        ByteArrayCache.getInstance().free(this.readBuf);
        this.inflater.end();
        this.inflater = null;
        ondone.unblock();
    }

    public IAsync<IOException> canStartReading() {
        return new Async(true);
    }

    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.isClosing() || this.isClosed()) {
            return new AsyncSupplier(null, null, new CancelException(ERROR_CLOSED));
        }
        if (this.reachEOF) {
            return IOUtil.success((Object)-1, ondone);
        }
        if (!this.inflater.needsInput()) {
            AsyncSupplier result = new AsyncSupplier();
            Task.cpu((String)("Uncompressing zip: " + this.input.getSourceDescription()), (Task.Priority)this.priority, t -> {
                this.readBufferAsync(buffer, ondone, (AsyncSupplier<Integer, IOException>)result);
                return null;
            }).start();
            return (AsyncSupplier)this.operation((IAsync)result);
        }
        if (this.inflater.finished()) {
            this.reachEOF = true;
            return IOUtil.success((Object)-1, ondone);
        }
        AsyncSupplier result = new AsyncSupplier();
        this.fillAsync(buffer, (AsyncSupplier<Integer, IOException>)result, ondone);
        return (AsyncSupplier)this.operation((IAsync)result);
    }

    public int readSync(ByteBuffer buffer) throws IOException {
        if (this.isClosing() || this.isClosed()) {
            throw new IOException(ERROR_CLOSED);
        }
        return this.readBufferSync(buffer);
    }

    private int readBufferSync(ByteBuffer buffer) throws IOException {
        if (this.reachEOF) {
            return -1;
        }
        ByteArray b = ByteArray.fromByteBuffer((ByteBuffer)buffer);
        try {
            int n;
            while ((n = this.inflater.inflate((byte[])b.getArray(), b.getCurrentArrayOffset(), buffer.remaining())) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    this.reachEOF = true;
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fillSync();
            }
            if (!buffer.hasArray()) {
                buffer.put((byte[])b.getArray(), 0, n);
            } else {
                buffer.position(buffer.position() + n);
            }
            return n;
        }
        catch (DataFormatException e) {
            throw new IOException("Inflate error after " + this.inflater.getBytesRead() + " compressed bytes read, and " + this.inflater.getBytesWritten() + " uncompressed bytes written", e);
        }
    }

    private void readBufferAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone, AsyncSupplier<Integer, IOException> result) {
        ByteArray b = ByteArray.fromByteBuffer((ByteBuffer)buffer);
        try {
            int total = 0;
            while (true) {
                int n;
                if ((n = this.inflater.inflate((byte[])b.getArray(), b.getCurrentArrayOffset() + total, buffer.remaining() - total)) == 0 && total <= 0) {
                    if (this.inflater.finished() || this.inflater.needsDictionary()) {
                        this.reachEOF = true;
                        IOUtil.success((Object)-1, result, ondone);
                        return;
                    }
                    if (this.isClosing() || this.isClosed()) {
                        IOUtil.error((Exception)new IOException(ERROR_CLOSED), result, ondone);
                        return;
                    }
                    if (!this.inflater.needsInput()) continue;
                    this.fillAsync(buffer, result, ondone);
                    return;
                }
                if (n <= 0 || (total += n) >= buffer.remaining() || this.inflater.needsInput()) break;
            }
            if (!buffer.hasArray()) {
                buffer.put((byte[])b.getArray(), 0, total);
            } else {
                buffer.position(buffer.position() + total);
            }
            IOUtil.success((Object)total, result, ondone);
        }
        catch (DataFormatException e) {
            IOUtil.error((Exception)new IOException("Inflate error after " + this.inflater.getBytesRead() + " compressed bytes read, and " + this.inflater.getBytesWritten() + " uncompressed bytes written", e), result, ondone);
        }
    }

    private void fillSync() throws IOException {
        if (this.isClosing() || this.isClosed()) {
            throw new IOException(ERROR_CLOSED);
        }
        this.readBuf.clear();
        int len = this.input.readSync(this.readBuf);
        if (len <= 0) {
            throw new IOException("Unexpected end of zip input");
        }
        this.inflater.setInput(this.readBuf.array(), 0, len);
    }

    private void fillAsync(ByteBuffer buffer, AsyncSupplier<Integer, IOException> result, Consumer<Pair<Integer, IOException>> ondone) {
        this.readBuf.clear();
        AsyncSupplier read = this.input.readAsync(this.readBuf);
        Task.cpu((String)("Uncompressing zip: " + this.input.getSourceDescription()), (Task.Priority)this.priority, task -> {
            if (!read.isSuccessful()) {
                IOUtil.notSuccess((IAsync)read, (AsyncSupplier)result, (Consumer)ondone);
                return null;
            }
            int len = (Integer)read.getResult();
            if (len <= 0) {
                if (this.isClosing() || this.isClosed()) {
                    result.cancel(new CancelException(ERROR_CLOSED));
                } else {
                    IOUtil.error((Exception)new IOException("Unexpected end of zip input"), (AsyncSupplier)result, (Consumer)ondone);
                }
                return null;
            }
            this.inflater.setInput(this.readBuf.array(), 0, len);
            this.readBufferAsync(buffer, ondone, result);
            return null;
        }).startOn((IAsync)read, true);
    }

    public int readFullySync(ByteBuffer buffer) throws IOException {
        if (this.reachEOF) {
            return -1;
        }
        return IOUtil.readFully((IO.Readable)this, (ByteBuffer)buffer);
    }

    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return (AsyncSupplier)this.operation((IAsync)IOUtil.readFullyAsync((IO.Readable)this, (ByteBuffer)buffer, ondone));
    }

    public long skipSync(long n) throws IOException {
        return IOUtil.skipSyncByReading((IO.Readable)this, (long)n);
    }

    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return (AsyncSupplier)this.operation((IAsync)IOUtil.skipAsyncByReading((IO.Readable)this, (long)n, ondone));
    }

    public static class SizeKnown
    extends DeflateReadable
    implements IO.KnownSize {
        private long uncompressedSize;

        public SizeKnown(IO.Readable input, Task.Priority priority, long uncompressedSize, boolean nowrap, int bufferSize) {
            super(input, priority, nowrap, bufferSize);
            this.uncompressedSize = uncompressedSize;
        }

        public AsyncSupplier<Long, IOException> getSizeAsync() {
            return new AsyncSupplier((Object)this.uncompressedSize, null);
        }

        public long getSizeSync() {
            return this.uncompressedSize;
        }
    }
}

