/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.deflate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.zip.Deflater;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.LimitWriteOperations;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class DeflateWritable
extends ConcurrentCloseable<IOException>
implements IO.Writable {
    protected IO.Writable output;
    protected Task.Priority priority;
    protected Deflater deflater;
    protected ByteArrayCache bufferCache;
    protected LimitWriteOperations writeOps;
    protected Async<IOException> finishing = null;

    public DeflateWritable(IO.Writable output, Task.Priority priority, int level, boolean nowrap, int maxPendingWrite) {
        this.output = output;
        this.priority = priority;
        this.deflater = new Deflater(level, nowrap);
        this.writeOps = new LimitWriteOperations(output, maxPendingWrite, null);
        this.bufferCache = ByteArrayCache.getInstance();
    }

    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    public IO getWrappedIO() {
        return null;
    }

    public String getSourceDescription() {
        return "Zip compression to " + this.output.getSourceDescription();
    }

    public Task.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Task.Priority priority) {
        this.priority = priority;
    }

    protected IAsync<IOException> closeUnderlyingResources() {
        if (this.finishing == null) {
            this.finishAsync();
        }
        Async sp = new Async();
        this.finishing.onDone(() -> {
            IAsync close = this.output.closeAsync();
            close.onDone(() -> {
                if (!this.finishing.forwardIfNotSuccessful((IAsync)sp)) {
                    close.onDone(sp);
                }
            });
        });
        return sp;
    }

    protected void closeResources(Async<IOException> ondone) {
        this.output = null;
        this.deflater = null;
        this.writeOps = null;
        ondone.unblock();
    }

    public IAsync<IOException> canStartWriting() {
        return new Async(true);
    }

    private int setInput(ByteBuffer buffer) {
        int len = buffer.remaining();
        if (buffer.hasArray()) {
            this.deflater.setInput(buffer.array(), buffer.arrayOffset() + buffer.position(), len);
            buffer.position(buffer.position() + len);
        } else {
            byte[] buf = new byte[len];
            buffer.get(buf);
            this.deflater.setInput(buf);
        }
        return len;
    }

    public int writeSync(ByteBuffer buffer) throws IOException {
        int nb;
        int len = this.setInput(buffer);
        byte[] writeBuf = (byte[])this.bufferCache.get(len > 131072 ? 131072 : len, true);
        AsyncSupplier lastWrite = this.writeOps.getLastPendingOperation();
        if (lastWrite != null) {
            lastWrite.blockException(0L);
        }
        while (!this.deflater.needsInput() && (nb = this.deflater.deflate(writeBuf, 0, writeBuf.length)) > 0) {
            this.output.writeSync(ByteBuffer.wrap(writeBuf, 0, nb).asReadOnlyBuffer());
        }
        this.bufferCache.free((Object)writeBuf);
        return len;
    }

    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(Task.cpu((String)"Compressing data using deflate", (Task.Priority)this.priority, t -> {
            byte[] writeBuf;
            int nb;
            int len = this.setInput(buffer);
            while (!this.deflater.needsInput() && (nb = this.deflater.deflate(writeBuf = (byte[])this.bufferCache.get(len > 8192 ? 8192 : len, true), 0, writeBuf.length)) > 0) {
                AsyncSupplier write = this.writeOps.write((Object)ByteBuffer.wrap(writeBuf, 0, nb));
                if (!write.hasError()) continue;
                throw (IOException)write.getError();
            }
            return len;
        }, ondone).start()).getOutput();
    }

    public void finishSynch() throws IOException {
        if (this.finishing != null) {
            this.finishing.blockException(0L);
            return;
        }
        this.finishing = new Async();
        try {
            AsyncSupplier lastWrite = this.writeOps.getLastPendingOperation();
            if (lastWrite != null) {
                lastWrite.blockException(0L);
            }
            this.deflater.finish();
            if (!this.deflater.finished()) {
                int nb;
                byte[] writeBuf = (byte[])this.bufferCache.get(8192, true);
                while ((nb = this.deflater.deflate(writeBuf, 0, writeBuf.length)) > 0) {
                    this.output.writeSync(ByteBuffer.wrap(writeBuf, 0, nb).asReadOnlyBuffer());
                    if (!this.deflater.finished()) continue;
                }
                this.bufferCache.free((Object)writeBuf);
            }
            this.finishing.unblock();
        }
        catch (IOException e) {
            this.finishing.error((Exception)e);
            throw e;
        }
    }

    public IAsync<IOException> finishAsync() {
        if (this.finishing != null) {
            return this.finishing;
        }
        this.finishing = new Async();
        Task.cpu((String)"Finishing zip compression", (Task.Priority)this.priority, task -> {
            AsyncSupplier lastWrite = null;
            this.deflater.finish();
            if (!this.deflater.finished()) {
                byte[] writeBuf;
                int nb;
                while ((nb = this.deflater.deflate(writeBuf = (byte[])this.bufferCache.get(8192, true), 0, writeBuf.length)) > 0) {
                    try {
                        lastWrite = this.writeOps.write((Object)ByteBuffer.wrap(writeBuf, 0, nb));
                    }
                    catch (IOException e) {
                        this.finishing.error((Exception)e);
                        return null;
                    }
                    if (!this.deflater.finished()) continue;
                }
            }
            if (lastWrite == null) {
                lastWrite = this.writeOps.getLastPendingOperation();
            }
            if (lastWrite != null) {
                lastWrite.onDone(this.finishing);
            } else {
                this.finishing.unblock();
            }
            return null;
        }).start();
        Async op = (Async)this.operation((IAsync)new Async());
        this.finishing.onDone(op);
        return this.finishing;
    }
}

