/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.deflate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class DeflateReadable
extends ConcurrentCloseable
implements IO.Readable {
    private IO.Readable input;
    private byte priority;
    private Inflater inflater;
    private ByteBuffer readBuf = ByteBuffer.allocate(8192);
    private AsyncWork<Integer, IOException> readTask = null;
    private boolean reachEOF = false;

    public DeflateReadable(IO.Readable input, byte priority, boolean nowrap) {
        this.inflater = new Inflater(nowrap);
        this.input = input;
        this.priority = priority;
    }

    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public String getSourceDescription() {
        return "Deflate stream: " + (this.input != null ? this.input.getSourceDescription() : "closed");
    }

    public IO getWrappedIO() {
        return null;
    }

    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.input.closeAsync();
    }

    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.input = null;
        this.readBuf = null;
        this.readTask = null;
        this.inflater.end();
        this.inflater = null;
        ondone.unblock();
    }

    public ISynchronizationPoint<IOException> canStartReading() {
        return new SynchronizationPoint(true);
    }

    public AsyncWork<Integer, IOException> readAsync(final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (this.isClosing() || this.isClosed()) {
            return new AsyncWork(null, null, new CancelException("Deflate stream closed"));
        }
        if (this.reachEOF) {
            if (ondone != null) {
                ondone.run((Object)new Pair((Object)-1, null));
            }
            return new AsyncWork((Object)-1, null);
        }
        if (this.readTask != null && !this.readTask.isUnblocked()) {
            Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Waiting for previous uncompression task", this.priority, ondone){

                public Integer run() throws IOException {
                    return DeflateReadable.this.readBufferSync(buffer);
                }
            };
            this.readTask.listenAsync((Task)task, false);
            this.readTask = this.operation((Task)task).getOutput();
            return task.getOutput();
        }
        if (!this.inflater.needsInput()) {
            final AsyncWork result = new AsyncWork();
            Task.Cpu<Void, NoException> inflate = new Task.Cpu<Void, NoException>("Uncompressing zip: " + this.input.getSourceDescription(), this.priority){

                public Void run() {
                    DeflateReadable.this.readBufferAsync(buffer, (RunnableWithParameter<Pair<Integer, IOException>>)ondone, (AsyncWork<Integer, IOException>)result);
                    return null;
                }
            };
            inflate.start();
            this.readTask = (AsyncWork)this.operation((ISynchronizationPoint)result);
            return result;
        }
        if (this.inflater.finished()) {
            this.reachEOF = true;
            if (ondone != null) {
                ondone.run((Object)new Pair((Object)-1, null));
            }
            return new AsyncWork((Object)-1, null);
        }
        AsyncWork result = new AsyncWork();
        this.fillAsync(buffer, (AsyncWork<Integer, IOException>)result, ondone);
        this.readTask = (AsyncWork)this.operation((ISynchronizationPoint)result);
        return this.readTask;
    }

    public int readSync(ByteBuffer buffer) throws IOException {
        if (this.readTask != null) {
            try {
                this.readTask.blockThrow(0L);
            }
            catch (CancelException cancel) {
                return -1;
            }
            catch (Exception err) {
                throw IO.error((Throwable)err);
            }
        }
        return this.readBufferSync(buffer);
    }

    private int readBufferSync(ByteBuffer buffer) throws IOException {
        int off;
        byte[] b;
        if (this.reachEOF) {
            return -1;
        }
        if (buffer.hasArray()) {
            b = buffer.array();
            off = buffer.arrayOffset() + buffer.position();
        } else {
            b = new byte[buffer.remaining()];
            off = 0;
        }
        try {
            int n;
            while ((n = this.inflater.inflate(b, off, buffer.remaining())) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    this.reachEOF = true;
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fillSync();
            }
            if (!buffer.hasArray()) {
                buffer.put(b, 0, n);
            } else {
                buffer.position(off + n - buffer.arrayOffset());
            }
            return n;
        }
        catch (DataFormatException e) {
            throw new IOException("Inflate error after " + this.inflater.getBytesRead() + " compressed bytes read, and " + this.inflater.getBytesWritten() + " uncompressed bytes written", e);
        }
    }

    private void readBufferAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone, AsyncWork<Integer, IOException> result) {
        int off;
        byte[] b;
        if (buffer.hasArray()) {
            b = buffer.array();
            off = buffer.arrayOffset() + buffer.position();
        } else {
            b = new byte[buffer.remaining()];
            off = 0;
        }
        try {
            int total = 0;
            while (true) {
                int n;
                if ((n = this.inflater.inflate(b, off + total, buffer.remaining() - total)) == 0 && total <= 0) {
                    if (this.inflater.finished() || this.inflater.needsDictionary()) {
                        this.reachEOF = true;
                        if (ondone != null) {
                            ondone.run((Object)new Pair((Object)-1, null));
                        }
                        result.unblockSuccess((Object)-1);
                        return;
                    }
                    if (!this.inflater.needsInput()) continue;
                    this.fillAsync(buffer, result, ondone);
                    return;
                }
                if (n <= 0 || (total += n) >= buffer.remaining() || this.inflater.needsInput()) break;
            }
            if (!buffer.hasArray()) {
                buffer.put(b, 0, total);
            } else {
                buffer.position(off + total - buffer.arrayOffset());
            }
            Integer r = total;
            if (ondone != null) {
                ondone.run((Object)new Pair((Object)r, null));
            }
            result.unblockSuccess((Object)r);
        }
        catch (DataFormatException e) {
            IOException err = new IOException("Inflate error after " + this.inflater.getBytesRead() + " compressed bytes read, and " + this.inflater.getBytesWritten() + " uncompressed bytes written", e);
            if (ondone != null) {
                ondone.run((Object)new Pair(null, (Object)err));
            }
            result.error((Exception)err);
        }
    }

    private void fillSync() throws IOException {
        this.readBuf.clear();
        int len = this.input.readSync(this.readBuf);
        if (len <= 0) {
            throw new IOException("Unexpected end of zip input");
        }
        this.inflater.setInput(this.readBuf.array(), 0, len);
    }

    private void fillAsync(final ByteBuffer buffer, final AsyncWork<Integer, IOException> result, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        this.readBuf.clear();
        final AsyncWork read = this.input.readAsync(this.readBuf);
        Task.Cpu<Void, NoException> inflate = new Task.Cpu<Void, NoException>("Uncompressing zip: " + this.input.getSourceDescription(), this.priority){

            public Void run() {
                if (read.hasError()) {
                    if (ondone != null) {
                        ondone.run((Object)new Pair(null, (Object)read.getError()));
                    }
                    result.error(read.getError());
                    return null;
                }
                if (read.isCancelled()) {
                    result.cancel(read.getCancelEvent());
                    return null;
                }
                int len = (Integer)read.getResult();
                if (len <= 0) {
                    if (DeflateReadable.this.isClosing() || DeflateReadable.this.isClosed()) {
                        result.cancel(new CancelException("Deflate stream closed"));
                    } else {
                        IOException err = new IOException("Unexpected end of zip input");
                        if (ondone != null) {
                            ondone.run((Object)new Pair(null, (Object)err));
                        }
                        result.error((Exception)err);
                    }
                    return null;
                }
                DeflateReadable.this.inflater.setInput(DeflateReadable.this.readBuf.array(), 0, len);
                DeflateReadable.this.readBufferAsync(buffer, (RunnableWithParameter<Pair<Integer, IOException>>)ondone, (AsyncWork<Integer, IOException>)result);
                return null;
            }
        };
        inflate.startOn((ISynchronizationPoint)read, true);
    }

    public int readFullySync(ByteBuffer buffer) throws IOException {
        if (this.reachEOF) {
            return -1;
        }
        if (this.readTask != null) {
            try {
                this.readTask.blockThrow(0L);
            }
            catch (CancelException e) {
                return -1;
            }
            catch (Exception e) {
                throw IO.error((Throwable)e);
            }
        }
        return IOUtil.readFully((IO.Readable)this, (ByteBuffer)buffer);
    }

    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return (AsyncWork)this.operation((ISynchronizationPoint)IOUtil.readFullyAsync((IO.Readable)this, (ByteBuffer)buffer, ondone));
    }

    public long skipSync(long n) throws IOException {
        return IOUtil.skipSyncByReading((IO.Readable)this, (long)n);
    }

    public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return (AsyncWork)this.operation((ISynchronizationPoint)IOUtil.skipAsyncByReading((IO.Readable)this, (long)n, ondone));
    }

    public static class SizeKnown
    extends DeflateReadable
    implements IO.KnownSize {
        private long uncompressedSize;

        public SizeKnown(IO.Readable input, byte priority, long uncompressedSize, boolean nowrap) {
            super(input, priority, nowrap);
            this.uncompressedSize = uncompressedSize;
        }

        public AsyncWork<Long, IOException> getSizeAsync() {
            return new AsyncWork((Object)this.uncompressedSize, null);
        }

        public long getSizeSync() {
            return this.uncompressedSize;
        }
    }
}

