/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.deflate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.LimitWriteOperations;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class DeflateWritable
extends ConcurrentCloseable
implements IO.Writable {
    protected IO.Writable output;
    protected byte priority;
    protected Deflater deflater;
    protected LimitWriteOperations writeOps;

    public DeflateWritable(IO.Writable output, byte priority, int level, boolean nowrap, int maxPendingWrite) {
        this.output = output;
        this.priority = priority;
        this.deflater = new Deflater(level, nowrap);
        this.writeOps = new LimitWriteOperations(output, maxPendingWrite);
    }

    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    public IO getWrappedIO() {
        return null;
    }

    public String getSourceDescription() {
        return "Zip compression to " + this.output.getSourceDescription();
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.output.closeAsync();
    }

    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.output = null;
        this.deflater = null;
        this.writeOps = null;
        ondone.unblock();
    }

    public ISynchronizationPoint<IOException> canStartWriting() {
        return new SynchronizationPoint(true);
    }

    public int writeSync(ByteBuffer buffer) throws IOException {
        int nb;
        int len = buffer.remaining();
        if (buffer.hasArray()) {
            this.deflater.setInput(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + buffer.remaining());
        } else {
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            this.deflater.setInput(buf);
        }
        byte[] writeBuf = new byte[len > 131072 ? 131072 : len];
        AsyncWork lastWrite = this.writeOps.getLastPendingOperation();
        if (lastWrite != null) {
            lastWrite.blockException(0L);
        }
        while (!this.deflater.needsInput() && (nb = this.deflater.deflate(writeBuf, 0, writeBuf.length)) > 0) {
            this.output.writeSync(ByteBuffer.wrap(writeBuf, 0, nb));
        }
        return len;
    }

    public AsyncWork<Integer, IOException> writeAsync(final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Compressing data using deflate", this.priority, ondone){

            public Integer run() throws IOException {
                byte[] writeBuf;
                int nb;
                if (this.isCancelled()) {
                    return 0;
                }
                int len = buffer.remaining();
                if (buffer.hasArray()) {
                    DeflateWritable.this.deflater.setInput(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                    buffer.position(buffer.position() + buffer.remaining());
                } else {
                    byte[] buf = new byte[buffer.remaining()];
                    buffer.get(buf);
                    DeflateWritable.this.deflater.setInput(buf);
                }
                while (!DeflateWritable.this.deflater.needsInput() && (nb = DeflateWritable.this.deflater.deflate(writeBuf = new byte[len > 8192 ? 8192 : len], 0, writeBuf.length)) > 0) {
                    DeflateWritable.this.writeOps.write(ByteBuffer.wrap(writeBuf, 0, nb));
                }
                return len;
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }

    public void finishSynch() throws IOException {
        AsyncWork lastWrite = this.writeOps.getLastPendingOperation();
        if (lastWrite != null) {
            lastWrite.blockException(0L);
        }
        this.deflater.finish();
        if (!this.deflater.finished()) {
            int nb;
            byte[] writeBuf = new byte[8192];
            while ((nb = this.deflater.deflate(writeBuf, 0, writeBuf.length)) > 0) {
                this.output.writeSync(ByteBuffer.wrap(writeBuf, 0, nb));
                if (!this.deflater.finished()) continue;
            }
        }
    }

    public ISynchronizationPoint<IOException> finishAsync() {
        final SynchronizationPoint result = new SynchronizationPoint();
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Finishing zip compression", this.priority){

            public Void run() {
                AsyncWork lastWrite = null;
                DeflateWritable.this.deflater.finish();
                if (!DeflateWritable.this.deflater.finished()) {
                    byte[] writeBuf;
                    int nb;
                    while ((nb = DeflateWritable.this.deflater.deflate(writeBuf = new byte[8192], 0, writeBuf.length)) > 0) {
                        try {
                            lastWrite = DeflateWritable.this.writeOps.write(ByteBuffer.wrap(writeBuf, 0, nb));
                        }
                        catch (IOException e) {
                            result.error((Exception)e);
                            return null;
                        }
                        if (!DeflateWritable.this.deflater.finished()) continue;
                    }
                }
                if (lastWrite == null) {
                    lastWrite = DeflateWritable.this.writeOps.getLastPendingOperation();
                }
                if (lastWrite != null) {
                    lastWrite.listenInline(result);
                } else {
                    result.unblock();
                }
                return null;
            }
        };
        task.start();
        return this.operation((ISynchronizationPoint)result);
    }
}

