/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.gzip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Inflater;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.text.StringUtil;

public class GZipConsumer
implements AsyncConsumer<ByteBuffer, IOException> {
    private AsyncConsumer<ByteBuffer, IOException> unzipConsumer;
    private Inflater inflater;
    private HeaderConsumer header;
    private int unzipBufferSize;
    private int trailerNeeded = 0;
    private ByteArrayCache cache = ByteArrayCache.getInstance();

    public GZipConsumer(int unzipBufferSize, AsyncConsumer<ByteBuffer, IOException> unzipConsumer) {
        this.unzipConsumer = unzipConsumer;
        this.header = new HeaderConsumer();
        this.inflater = new Inflater(true);
        this.unzipBufferSize = unzipBufferSize;
    }

    public GZipConsumer(AsyncConsumer<ByteBuffer, IOException> unzipConsumer) {
        this(8192, unzipConsumer);
    }

    public IAsync<IOException> end() {
        if (this.trailerNeeded < 8 && (this.header == null || this.header.pos != 0)) {
            IOException error = new IOException("Unexpected end of GZip data");
            this.unzipConsumer.error((Exception)error);
            return new Async((Exception)error);
        }
        this.inflater.end();
        return this.unzipConsumer.end();
    }

    public void error(IOException error) {
        this.inflater.end();
        this.unzipConsumer.error((Exception)error);
    }

    public IAsync<IOException> consume(ByteBuffer data) {
        Async result = new Async();
        this.consume(data, (Async<IOException>)result);
        return result;
    }

    private void consume(ByteBuffer data, Async<IOException> result) {
        if (this.trailerNeeded > 0) {
            int l = Math.min(this.trailerNeeded, data.remaining());
            data.position(data.position() + l);
            this.trailerNeeded -= l;
            if (this.trailerNeeded == 0) {
                this.header = new HeaderConsumer();
                if (!data.hasRemaining()) {
                    this.cache.free(data);
                    result.unblock();
                    return;
                }
            } else {
                if (!data.hasRemaining()) {
                    this.cache.free(data);
                }
                result.unblock();
                return;
            }
        }
        if (this.header != null) {
            try {
                if (!this.header.consume(data)) {
                    this.cache.free(data);
                    result.unblock();
                    return;
                }
            }
            catch (IOException e) {
                result.error((Exception)e);
                this.inflater.end();
                this.unzipConsumer.error((Exception)e);
                return;
            }
            this.header = null;
            if (!data.hasRemaining()) {
                this.cache.free(data);
                result.unblock();
                return;
            }
        }
        if (data.hasArray()) {
            this.inflater.setInput(data.array(), data.arrayOffset() + data.position(), data.remaining());
        } else {
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.inflater.setInput(b);
        }
        this.doInflate(data, result);
    }

    private void doInflate(ByteBuffer data, Async<IOException> result) {
        int n;
        byte[] unzipBuffer = (byte[])this.cache.get(this.unzipBufferSize, true);
        try {
            n = this.inflater.inflate(unzipBuffer);
        }
        catch (Exception e) {
            this.inflater.end();
            IOException err = new IOException("Invalid GZip data", e);
            this.unzipConsumer.error((Exception)err);
            result.error((Exception)err);
            return;
        }
        if (n > 0) {
            IAsync consume = this.unzipConsumer.consume((Object)ByteBuffer.wrap(unzipBuffer, 0, n));
            consume.thenStart("Continue to unzip data", null, () -> this.afterInflate(data, result), result);
            return;
        }
        this.afterInflate(data, result);
    }

    private void afterInflate(ByteBuffer data, Async<IOException> result) {
        data.position(data.limit() - this.inflater.getRemaining());
        if (this.inflater.finished() || this.inflater.needsDictionary()) {
            this.trailerNeeded = 8;
            this.inflater.reset();
            if (!data.hasRemaining()) {
                this.cache.free(data);
                result.unblock();
            } else {
                this.consume(data, result);
            }
            return;
        }
        if (this.inflater.needsInput()) {
            this.cache.free(data);
            result.unblock();
            return;
        }
        this.doInflate(data, result);
    }

    private static class HeaderConsumer {
        private int pos = 0;
        private int toSkip = 0;
        private byte flags;
        private int shortLen = 0;
        private int shortLenPos = 0;

        private HeaderConsumer() {
        }

        public boolean consume(ByteBuffer data) throws IOException {
            while (data.hasRemaining()) {
                if (this.pos <= 3) {
                    this.readFirstBytes(data.get());
                    ++this.pos;
                    continue;
                }
                if (this.pos <= 9) {
                    int r = 6 - (this.pos - 4);
                    int l = Math.min(r, data.remaining());
                    data.position(data.position() + l);
                    this.pos += l;
                    if (l < r || !data.hasRemaining()) break;
                }
                if (this.pos == 10) {
                    if ((this.flags & 4) != 0 && !this.skipExtra(data)) {
                        return false;
                    }
                    ++this.pos;
                }
                if (this.pos == 11) {
                    if ((this.flags & 8) != 0 && !this.skipString(data)) {
                        return false;
                    }
                    ++this.pos;
                }
                if (this.pos == 12) {
                    if ((this.flags & 0x10) != 0 && !this.skipString(data)) {
                        return false;
                    }
                    ++this.pos;
                }
                if ((this.flags & 2) != 0) {
                    if (this.toSkip == 1) {
                        data.position(data.position() + 1);
                        return true;
                    }
                    if (data.remaining() == 1) {
                        data.position(data.position() + 1);
                        this.toSkip = 1;
                        return false;
                    }
                    data.position(data.position() + 2);
                }
                return true;
            }
            return false;
        }

        private void readFirstBytes(byte b) throws IOException {
            switch (this.pos) {
                case 0: {
                    if (b == 31) break;
                    throw new IOException("Invalid GZIP header: first byte must be 1F, " + StringUtil.encodeHexa((byte)b) + " found");
                }
                case 1: {
                    if (b == -117) break;
                    throw new IOException("Invalid GZIP header: second byte must be 8B, " + StringUtil.encodeHexa((byte)b) + " found");
                }
                case 2: {
                    if (b == 8) break;
                    throw new IOException("Unsupported compression method " + b + " for GZIP, only method 8 (deflate) is supported");
                }
                case 3: {
                    this.flags = b;
                    break;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean skipExtra(ByteBuffer data) {
            block4: while (true) lbl-1000:
            // 3 sources

            {
                switch (this.shortLenPos) {
                    case 0: {
                        this.shortLen = data.get() & 255;
                        ++this.shortLenPos;
                        if (data.hasRemaining()) ** GOTO lbl-1000
                        return false;
                    }
                    case 1: {
                        this.toSkip = this.shortLen | (data.get() & 255) << 8;
                        ++this.shortLenPos;
                        if (data.hasRemaining()) continue block4;
                        return false;
                    }
                }
                break;
            }
            l = Math.min(this.toSkip, data.remaining());
            data.position(data.position() + l);
            this.toSkip -= l;
            if (this.toSkip > 0) {
                return false;
            }
            this.shortLenPos = 0;
            if (!data.hasRemaining()) {
                ++this.pos;
                return false;
            }
            return true;
        }

        private boolean skipString(ByteBuffer data) {
            do {
                if (data.get() != 0) continue;
                if (!data.hasRemaining()) {
                    ++this.pos;
                    return false;
                }
                return true;
            } while (data.hasRemaining());
            return false;
        }
    }
}

