/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.gzip;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.util.DataUtil;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.text.StringUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class GZipReadable
extends ConcurrentCloseable<IOException>
implements IO.Readable {
    private IO.Readable.Buffered input;
    private Task.Priority priority;
    private Inflater inflater;
    private Async<IOException> header;
    private ByteArray currentBuffer = null;
    private IOException error = null;
    private boolean eof = false;
    private AsyncSupplier<Integer, IOException> currentRead = null;

    public GZipReadable(IO.Readable.Buffered input, Task.Priority priority) {
        this.input = input;
        this.priority = priority;
        this.header = new Async();
        this.readHeader();
        this.inflater = new Inflater(true);
    }

    public Task.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Task.Priority priority) {
        this.priority = priority;
    }

    protected IAsync<IOException> closeUnderlyingResources() {
        return this.input.closeAsync();
    }

    protected void closeResources(Async<IOException> ondone) {
        this.input = null;
        this.currentBuffer = null;
        this.inflater.end();
        this.inflater = null;
        ondone.unblock();
    }

    public IAsync<IOException> canStartReading() {
        return this.header;
    }

    private Async<NoException> nextBuffer() {
        Async sp = new Async();
        AsyncSupplier read = this.input.readNextBufferAsync();
        read.onDone(() -> {
            if (read.hasError()) {
                this.error = (IOException)read.getError();
            } else if (read.isCancelled()) {
                this.error = IO.errorCancelled((CancelException)read.getCancelEvent());
            } else {
                ByteBuffer b;
                if (this.currentBuffer != null) {
                    this.currentBuffer.free();
                }
                if ((b = (ByteBuffer)read.getResult()) == null) {
                    this.eof = true;
                    this.currentBuffer = null;
                    sp.unblock();
                    return;
                }
                this.currentBuffer = ByteArray.fromByteBuffer((ByteBuffer)b);
            }
            sp.unblock();
        });
        return sp;
    }

    private void readHeader() {
        if (this.error != null) {
            this.header.error((Exception)this.error);
            return;
        }
        if (this.eof) {
            this.header.unblock();
            return;
        }
        if (this.currentBuffer == null || !this.currentBuffer.hasRemaining()) {
            this.nextBuffer().onDone(this::readHeader);
            return;
        }
        Task.cpu((String)"Read GZip header", (Task.Priority)this.priority, t -> this.readHeaderTask()).start();
    }

    private Void readHeaderTask() {
        if (this.currentBuffer.remaining() < 10 && !this.readHeaderEnsure10Bytes()) {
            return null;
        }
        int b = this.currentBuffer.get() & 0xFF;
        if (b != 31) {
            this.error = new IOException("Invalid GZIP header: first byte must be 1F, found is " + StringUtil.encodeHexa((byte)((byte)b)));
            this.header.error((Exception)this.error);
            return null;
        }
        b = this.currentBuffer.get() & 0xFF;
        if (b != 139) {
            this.error = new IOException("Invalid GZIP header: second byte must be 8B, found is " + StringUtil.encodeHexa((byte)((byte)b)));
            this.header.error((Exception)this.error);
            return null;
        }
        b = this.currentBuffer.get() & 0xFF;
        if (b != 8) {
            this.error = new IOException("Unsupported compression method " + b + " for GZIP, only method 8 (deflate) is supported");
            this.header.error((Exception)this.error);
            return null;
        }
        b = this.currentBuffer.get() & 0xFF;
        this.currentBuffer.moveForward(6);
        if ((b & 4) != 0 && !this.skipExtra()) {
            return null;
        }
        if ((b & 8) != 0 && !this.skipString()) {
            return null;
        }
        if ((b & 0x10) != 0 && !this.skipString()) {
            return null;
        }
        if ((b & 2) != 0) {
            try {
                switch (this.currentBuffer.remaining()) {
                    case 0: {
                        if (this.input.skip(2) != 2) {
                            throw new EOFException();
                        }
                        break;
                    }
                    case 1: {
                        if (this.input.skip(1) != 1) {
                            throw new EOFException();
                        }
                        this.currentBuffer.moveForward(1);
                        break;
                    }
                    default: {
                        this.currentBuffer.moveForward(2);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.error = e;
                this.header.error((Exception)e);
                return null;
            }
        }
        this.header.unblock();
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readHeaderEnsure10Bytes() {
        try {
            do lbl-1000:
            // 4 sources

            {
                block7: {
                    block6: {
                        if ((next = this.input.readNextBuffer()) == null) {
                            throw new EOFException();
                        }
                        if (this.currentBuffer.hasRemaining()) break block6;
                        this.currentBuffer.free();
                        this.currentBuffer = ByteArray.fromByteBuffer((ByteBuffer)next);
                        if (this.currentBuffer.remaining() < 10) ** GOTO lbl-1000
                        return true;
                    }
                    len = next.remaining();
                    r = this.currentBuffer.remaining();
                    if (!(this.currentBuffer instanceof ByteArray.Writable) || ((byte[])this.currentBuffer.getArray()).length < r + len) break block7;
                    b = (byte[])this.currentBuffer.getArray();
                    if (r > 0) {
                        System.arraycopy(b, this.currentBuffer.getCurrentArrayOffset(), b, 0, r);
                    }
                    next.get(b, r, len);
                    this.currentBuffer = new ByteArray.Writable(b, 0, r + len, true);
                    if (this.currentBuffer.remaining() < 10) ** GOTO lbl-1000
                    return true;
                }
                b = (byte[])ByteArrayCache.getInstance().get(r + len, true);
                this.currentBuffer.get(b, 0, r);
                next.get(b, r, len);
                ba = new ByteArray.Writable(b, 0, r + len, true);
                this.currentBuffer.free();
                this.currentBuffer = ba;
            } while (this.currentBuffer.remaining() < 10);
            return true;
        }
        catch (EOFException e) {
            this.error = new IOException("Unexpected end of GZIP data");
            this.header.error((Exception)this.error);
            return false;
        }
        catch (IOException e) {
            this.error = e;
            this.header.error((Exception)e);
            return false;
        }
    }

    private boolean skipString() {
        while (this.currentBuffer.hasRemaining()) {
            if (this.currentBuffer.get() != 0) continue;
            return true;
        }
        try {
            while (this.input.readByte() != 0) {
            }
            return true;
        }
        catch (IOException e) {
            this.error = e;
            this.header.error((Exception)e);
            return false;
        }
    }

    private boolean skipExtra() {
        try {
            int extraLen;
            switch (this.currentBuffer.remaining()) {
                case 0: {
                    extraLen = DataUtil.Read16U.LE.read((IO.ReadableByteStream)this.input);
                    break;
                }
                case 1: {
                    extraLen = this.currentBuffer.get() & 0xFF | (this.input.readByte() & 0xFF) << 8;
                    break;
                }
                default: {
                    extraLen = this.currentBuffer.get() & 0xFF;
                    extraLen |= (this.currentBuffer.get() & 0xFF) << 8;
                }
            }
            int rem = this.currentBuffer.remaining();
            if (rem >= extraLen) {
                this.currentBuffer.moveForward(extraLen);
            } else {
                this.currentBuffer.goToEnd();
                rem = extraLen - rem;
                int skipped = this.input.skip(rem);
                if (skipped != rem) {
                    throw new EOFException(skipped + " byte(s) of extra data, expected is " + rem);
                }
            }
            return true;
        }
        catch (IOException e) {
            this.error = e;
            this.header.error((Exception)e);
            return false;
        }
    }

    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(buffer, ondone, false);
    }

    private AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone, boolean isCurrent) {
        if (this.error != null) {
            return IOUtil.error((Exception)this.error, ondone);
        }
        if (!this.header.isDone()) {
            AsyncSupplier res;
            this.currentRead = res = new AsyncSupplier();
            this.header.onDone(() -> this.readAsync(buffer, ondone, true).forward(res));
            return (AsyncSupplier)this.operation((IAsync)res);
        }
        if (this.eof) {
            return IOUtil.success((Object)-1, ondone);
        }
        if (!isCurrent && this.currentRead != null && !this.currentRead.isDone()) {
            AsyncSupplier result = new AsyncSupplier();
            AsyncSupplier<Integer, IOException> previous = this.currentRead;
            this.currentRead = result;
            previous.onDone(() -> this.readAsync(buffer, ondone, true).forward(result));
            return (AsyncSupplier)this.operation((IAsync)result);
        }
        if (!this.inflater.needsInput()) {
            AsyncSupplier result = new AsyncSupplier();
            Task inflate = Task.cpu((String)("Uncompressing gzip: " + this.input.getSourceDescription()), (Task.Priority)this.priority, (Executable)new InflateTask(buffer, result, ondone, false));
            this.currentRead = result;
            this.operation(inflate.start());
            if (inflate.isCancelling()) {
                result.cancel(inflate.getCancelEvent());
            }
            return result;
        }
        AsyncSupplier result = new AsyncSupplier();
        if (!this.currentBuffer.hasRemaining()) {
            this.currentRead = result;
            this.nextBuffer().onDone(() -> this.readAsync(buffer, ondone, true).forward(result));
            return (AsyncSupplier)this.operation((IAsync)result);
        }
        Task inflate = Task.cpu((String)("Uncompressing gzip: " + this.input.getSourceDescription()), (Task.Priority)this.priority, (Executable)new InflateTask(buffer, result, ondone, true));
        this.currentRead = result;
        this.operation(inflate.start());
        if (inflate.isCancelling()) {
            result.cancel(inflate.getCancelEvent());
        }
        return result;
    }

    public String getSourceDescription() {
        return "GZIP: " + (this.input != null ? this.input.getSourceDescription() : "null");
    }

    public IO getWrappedIO() {
        return null;
    }

    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    public int readSync(ByteBuffer buffer) throws IOException {
        try {
            return (Integer)this.readAsync(buffer).blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled((CancelException)e);
        }
    }

    public int readFullySync(ByteBuffer buffer) throws IOException {
        try {
            return (Integer)this.readFullyAsync(buffer).blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled((CancelException)e);
        }
    }

    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return (AsyncSupplier)this.operation((IAsync)IOUtil.readFullyAsync((IO.Readable)this, (ByteBuffer)buffer, ondone));
    }

    public long skipSync(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        return IOUtil.skipSyncByReading((IO.Readable)this, (long)n);
    }

    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return (AsyncSupplier)this.operation((IAsync)IOUtil.skipAsyncByReading((IO.Readable)this, (long)n, ondone));
    }

    private class InflateTask
    implements Executable<Void, NoException> {
        private ByteBuffer buffer;
        private AsyncSupplier<Integer, IOException> inflateResult;
        private Consumer<Pair<Integer, IOException>> onInflateDone;
        private boolean setInput;

        private InflateTask(ByteBuffer buffer, AsyncSupplier<Integer, IOException> result, Consumer<Pair<Integer, IOException>> ondone, boolean setInput) {
            this.buffer = buffer;
            this.inflateResult = result;
            this.onInflateDone = ondone;
            this.setInput = setInput;
        }

        public Void execute(Task<Void, NoException> taskContext) throws CancelException {
            if (GZipReadable.this.isClosing() || GZipReadable.this.isClosed() || GZipReadable.this.input == null) {
                this.inflateResult.cancel(new CancelException("GZip closed"));
                return null;
            }
            if (this.setInput) {
                GZipReadable.this.inflater.setInput((byte[])GZipReadable.this.currentBuffer.getArray(), GZipReadable.this.currentBuffer.getCurrentArrayOffset(), GZipReadable.this.currentBuffer.remaining());
                GZipReadable.this.currentBuffer.goToEnd();
            }
            ByteArray b = ByteArray.fromByteBuffer((ByteBuffer)this.buffer);
            try {
                int n;
                int total = 0;
                do {
                    if (taskContext.isCancelling()) {
                        throw taskContext.getCancelEvent();
                    }
                    if (GZipReadable.this.isClosing() || GZipReadable.this.isClosed() || GZipReadable.this.input == null) {
                        this.inflateResult.cancel(new CancelException("GZip closed"));
                        return null;
                    }
                    n = GZipReadable.this.inflater.inflate((byte[])b.getArray(), b.getCurrentArrayOffset() + total, this.buffer.remaining() - total);
                    if (n > 0) {
                        total += n;
                    }
                    if (GZipReadable.this.inflater.finished() || GZipReadable.this.inflater.needsDictionary()) {
                        GZipReadable.this.currentBuffer.setPosition(GZipReadable.this.currentBuffer.length() - GZipReadable.this.inflater.getRemaining());
                        this.skipTrailer();
                        GZipReadable.this.header = new Async();
                        GZipReadable.this.readHeader();
                        GZipReadable.this.inflater.reset();
                        if (total > 0) break;
                        GZipReadable.this.header.onDone(() -> GZipReadable.this.readAsync(this.buffer, this.onInflateDone, true).forward(this.inflateResult));
                        return null;
                    }
                    if (!GZipReadable.this.inflater.needsInput()) continue;
                    if (total > 0) break;
                    GZipReadable.this.readAsync(this.buffer, this.onInflateDone, true).forward(this.inflateResult);
                    return null;
                } while (n > 0 && total < this.buffer.remaining() && !GZipReadable.this.inflater.needsInput());
                if (!this.buffer.hasArray()) {
                    this.buffer.put((byte[])b.getArray(), 0, total);
                } else {
                    this.buffer.position(this.buffer.position() + total);
                }
                IOUtil.success((Object)total, this.inflateResult, this.onInflateDone);
            }
            catch (DataFormatException e) {
                GZipReadable.this.error = new IOException("Invalid compressed data after " + GZipReadable.this.inflater.getBytesRead() + " bytes (" + GZipReadable.this.inflater.getBytesWritten() + " uncompressed)", e);
                IOUtil.error((Exception)GZipReadable.this.error, this.inflateResult, this.onInflateDone);
            }
            return null;
        }

        private void skipTrailer() {
            int rem = GZipReadable.this.currentBuffer.remaining();
            if (rem >= 8) {
                GZipReadable.this.currentBuffer.moveForward(8);
                return;
            }
            GZipReadable.this.currentBuffer.goToEnd();
            try {
                GZipReadable.this.input.skip(8 - rem);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class SizeKnown
    extends GZipReadable
    implements IO.KnownSize {
        private long uncompressedSize;

        public SizeKnown(IO.Readable.Buffered input, Task.Priority priority, long uncompressedSize) {
            super(input, priority);
            this.uncompressedSize = uncompressedSize;
        }

        public AsyncSupplier<Long, IOException> getSizeAsync() {
            return new AsyncSupplier((Object)this.uncompressedSize, null);
        }

        public long getSizeSync() {
            return this.uncompressedSize;
        }
    }
}

