/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.gzip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import net.lecousin.compression.deflate.DeflateWritable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.util.DataUtil;
import net.lecousin.framework.util.Pair;

public class GZipWritable
extends DeflateWritable {
    private Async<IOException> writeHeader = new Async();
    private CRC32 crc = new CRC32();

    public GZipWritable(IO.Writable out, Task.Priority priority, int level, int maxPendingWrites) {
        super(out, priority, level, true, maxPendingWrites);
        this.writeHeader();
        this.crc.reset();
    }

    public IAsync<IOException> canStartWriting() {
        return this.writeHeader;
    }

    public int writeSync(ByteBuffer buffer) throws IOException {
        this.writeHeader.blockException(0L);
        int pos = buffer.position();
        this.crc.update(buffer);
        buffer.position(pos);
        return super.writeSync(buffer);
    }

    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.writeHeader.hasError()) {
            return IOUtil.error((Exception)this.writeHeader.getError(), ondone);
        }
        if (!this.writeHeader.isDone()) {
            AsyncSupplier result = new AsyncSupplier();
            this.writeHeader.onDone(() -> this.writeAsync(buffer, ondone).forward(result));
            return (AsyncSupplier)this.operation((IAsync)result);
        }
        int initPos = buffer.position();
        AsyncSupplier write = super.writeAsync(buffer, null);
        AsyncSupplier result = new AsyncSupplier();
        this.operation(Task.cpu((String)"Update GZip CRC", (Task.Priority)this.getPriority(), t -> {
            if (write.forwardIfNotSuccessful((IAsync)result)) {
                return null;
            }
            int nb = (Integer)write.getResult();
            if (nb <= 0) {
                result.unblockSuccess(write.getResult());
                return null;
            }
            int newPos = buffer.position();
            int limit = buffer.limit();
            buffer.position(initPos);
            buffer.limit(initPos + nb);
            this.crc.update(buffer);
            buffer.limit(limit);
            buffer.position(newPos);
            result.unblockSuccess(write.getResult());
            return null;
        })).startOn((IAsync)write, true);
        return result;
    }

    public void finishSynch() throws IOException {
        this.writeHeader.blockException(0L);
        super.finishSynch();
        byte[] trailer = new byte[8];
        DataUtil.Write32U.LE.write((byte[])trailer, (int)0, (long)((int)this.crc.getValue()));
        DataUtil.Write32U.LE.write((byte[])trailer, (int)4, (long)this.deflater.getTotalIn());
        this.output.writeSync(ByteBuffer.wrap(trailer));
    }

    public IAsync<IOException> finishAsync() {
        Async result = new Async();
        if (this.writeHeader.forwardIfNotSuccessful((IAsync)result)) {
            this.finishing = result;
            return result;
        }
        if (!this.writeHeader.isDone()) {
            this.writeHeader.onDone(() -> {
                if (!this.writeHeader.isSuccessful()) {
                    this.finishing = result;
                    this.writeHeader.forwardIfNotSuccessful((IAsync)result);
                    return;
                }
                this.finishAsync().onDone(result);
            });
            return this.operation((IAsync)result);
        }
        IAsync finish = super.finishAsync();
        finish.thenStart("Write GZip trailer", this.getPriority(), t -> {
            byte[] trailer = new byte[8];
            DataUtil.Write32U.LE.write((byte[])trailer, (int)0, (long)((int)this.crc.getValue()));
            DataUtil.Write32U.LE.write((byte[])trailer, (int)4, (long)this.deflater.getTotalIn());
            this.output.writeAsync(ByteBuffer.wrap(trailer)).onDone(result);
            return null;
        }, (IAsync)result);
        return this.operation((IAsync)result);
    }

    private void writeHeader() {
        Task.cpu((String)"Prepare GZip header", (Task.Priority)this.getPriority(), t -> {
            byte[] header = new byte[10];
            header[0] = 31;
            header[1] = -117;
            header[2] = 8;
            header[3] = 0;
            DataUtil.Write32U.LE.write((byte[])header, (int)4, (long)(System.currentTimeMillis() / 1000L));
            header[8] = 0;
            header[9] = 0;
            this.output.writeAsync(ByteBuffer.wrap(header)).onDone(this.writeHeader);
            return null;
        }).start();
    }
}

