/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.gzip;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.util.DataUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;
import net.lecousin.framework.util.StringUtil;

public class GZipReadable
extends ConcurrentCloseable
implements IO.Readable {
    private IO.Readable.Buffered input;
    private byte priority;
    private Inflater inflater;
    private SynchronizationPoint<IOException> header;
    private byte[] currentBuffer = null;
    private int currentPos = 0;
    private int currentLen = 0;
    private IOException error = null;
    private boolean eof = false;
    private AsyncWork<Integer, IOException> currentRead = null;

    public GZipReadable(IO.Readable.Buffered input, byte priority) {
        this.input = input;
        this.priority = priority;
        this.header = new SynchronizationPoint();
        this.readHeader();
        this.inflater = new Inflater(true);
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.input.closeAsync();
    }

    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.input = null;
        this.currentBuffer = null;
        this.inflater.end();
        this.inflater = null;
        ondone.unblock();
    }

    public ISynchronizationPoint<IOException> canStartReading() {
        return this.header;
    }

    private SynchronizationPoint<NoException> nextBuffer() {
        final SynchronizationPoint sp = new SynchronizationPoint();
        AsyncWork read = this.input.readNextBufferAsync();
        read.listenInline(() -> {
            if (read.hasError()) {
                this.error = (IOException)read.getError();
            } else if (read.isCancelled()) {
                this.error = new IOException("Operation cancelled", read.getCancelEvent());
            } else {
                final ByteBuffer b = (ByteBuffer)read.getResult();
                if (b == null) {
                    this.eof = true;
                    this.currentBuffer = null;
                    this.currentPos = 0;
                    this.currentLen = 0;
                    sp.unblock();
                    return;
                }
                if (b.hasArray()) {
                    this.currentBuffer = b.array();
                    this.currentPos = b.arrayOffset() + b.position();
                    this.currentLen = b.arrayOffset() + b.limit();
                } else {
                    new Task.Cpu<Void, NoException>("Convert native buffer into java buffer", this.priority){

                        public Void run() {
                            GZipReadable.this.currentLen = b.remaining();
                            GZipReadable.access$202(GZipReadable.this, new byte[GZipReadable.this.currentLen]);
                            GZipReadable.this.currentPos = 0;
                            b.get(GZipReadable.this.currentBuffer);
                            sp.unblock();
                            return null;
                        }
                    }.start();
                    return;
                }
            }
            sp.unblock();
        });
        return sp;
    }

    private void readHeader() {
        if (this.error != null) {
            this.header.error((Exception)this.error);
            return;
        }
        if (this.eof) {
            this.header.unblock();
            return;
        }
        if (this.currentPos == this.currentLen) {
            this.nextBuffer().listenInline(() -> this.readHeader());
            return;
        }
        new Task.Cpu<Void, NoException>("Read GZip header", this.priority){

            public Void run() {
                block32: {
                    int b;
                    int nb;
                    if (GZipReadable.this.currentLen - GZipReadable.this.currentPos < 10) {
                        byte[] b2 = new byte[10];
                        int rem = GZipReadable.this.currentLen - GZipReadable.this.currentPos;
                        System.arraycopy(GZipReadable.this.currentBuffer, GZipReadable.this.currentPos, b2, 0, rem);
                        try {
                            nb = IOUtil.readFully((IO.ReadableByteStream)GZipReadable.this.input, (byte[])b2, (int)rem, (int)(10 - rem));
                        }
                        catch (IOException e) {
                            GZipReadable.this.error = e;
                            GZipReadable.this.header.error((Exception)e);
                            return null;
                        }
                        if (nb != 10 - rem) {
                            GZipReadable.this.error = new IOException("Unexpected end of GZIP data");
                            GZipReadable.this.header.error((Exception)GZipReadable.this.error);
                            return null;
                        }
                        GZipReadable.access$202(GZipReadable.this, b2);
                        GZipReadable.this.currentPos = 0;
                        GZipReadable.this.currentLen = 10;
                    }
                    if ((b = GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF) != 31) {
                        GZipReadable.this.error = new IOException("Invalid GZIP header: first byte must be 1F, found is " + StringUtil.encodeHexa((byte)((byte)b)));
                        GZipReadable.this.header.error((Exception)GZipReadable.this.error);
                        return null;
                    }
                    b = GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF;
                    if (b != 139) {
                        GZipReadable.this.error = new IOException("Invalid GZIP header: second byte must be 8B, found is " + StringUtil.encodeHexa((byte)((byte)b)));
                        GZipReadable.this.header.error((Exception)GZipReadable.this.error);
                        return null;
                    }
                    b = GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF;
                    if (b != 8) {
                        GZipReadable.this.error = new IOException("Unsupported compression method " + b + " for GZIP, only method 8 (deflate) is supported");
                        GZipReadable.this.header.error((Exception)GZipReadable.this.error);
                        return null;
                    }
                    b = GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF;
                    GZipReadable.this.currentPos = GZipReadable.this.currentPos + 6;
                    if ((b & 4) != 0) {
                        int extraLen;
                        if (GZipReadable.this.currentPos == GZipReadable.this.currentLen) {
                            try {
                                extraLen = DataUtil.readUnsignedShortLittleEndian((IO.ReadableByteStream)GZipReadable.this.input);
                            }
                            catch (IOException e) {
                                GZipReadable.this.error = e;
                                GZipReadable.this.header.error((Exception)e);
                                return null;
                            }
                        } else if (GZipReadable.this.currentPos == GZipReadable.this.currentLen - 1) {
                            try {
                                extraLen = GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF | (GZipReadable.this.input.readByte() & 0xFF) << 8;
                            }
                            catch (IOException e) {
                                GZipReadable.this.error = e;
                                GZipReadable.this.header.error((Exception)e);
                                return null;
                            }
                        } else {
                            extraLen = GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF;
                            extraLen |= (GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] & 0xFF) << 8;
                        }
                        if (GZipReadable.this.currentLen - GZipReadable.this.currentPos >= extraLen) {
                            GZipReadable.this.currentPos = GZipReadable.this.currentPos + extraLen;
                        } else {
                            nb = extraLen - (GZipReadable.this.currentLen - GZipReadable.this.currentPos);
                            try {
                                if (GZipReadable.this.input.skip(nb) != nb) {
                                    throw new EOFException();
                                }
                            }
                            catch (IOException e) {
                                GZipReadable.this.error = e;
                                GZipReadable.this.header.error((Exception)e);
                                return null;
                            }
                            GZipReadable.this.currentPos = GZipReadable.this.currentLen;
                        }
                    }
                    if ((b & 8) != 0 && !this.skipString()) {
                        return null;
                    }
                    if ((b & 0x10) != 0 && !this.skipString()) {
                        return null;
                    }
                    if ((b & 2) != 0) {
                        if (GZipReadable.this.currentPos == GZipReadable.this.currentLen) {
                            try {
                                if (GZipReadable.this.input.skip(2) != 2) {
                                    throw new EOFException();
                                }
                                break block32;
                            }
                            catch (IOException e) {
                                GZipReadable.this.error = e;
                                GZipReadable.this.header.error((Exception)e);
                                return null;
                            }
                        }
                        if (GZipReadable.this.currentPos == GZipReadable.this.currentLen - 1) {
                            GZipReadable.this.currentPos = GZipReadable.this.currentLen;
                            try {
                                if (GZipReadable.this.input.skip(1) != 1) {
                                    throw new EOFException();
                                }
                                break block32;
                            }
                            catch (IOException e) {
                                GZipReadable.this.error = e;
                                GZipReadable.this.header.error((Exception)e);
                                return null;
                            }
                        }
                        GZipReadable.this.currentPos = GZipReadable.this.currentPos + 2;
                    }
                }
                GZipReadable.this.header.unblock();
                return null;
            }

            private boolean skipString() {
                while (GZipReadable.this.currentPos < GZipReadable.this.currentLen) {
                    if (GZipReadable.this.currentBuffer[GZipReadable.this.currentPos++] != 0) continue;
                    return true;
                }
                try {
                    while (GZipReadable.this.input.readByte() != 0) {
                    }
                    return true;
                }
                catch (IOException e) {
                    GZipReadable.this.error = e;
                    GZipReadable.this.header.error((Exception)e);
                    return false;
                }
            }
        }.start();
    }

    private void skipTrailer() {
        int rem = this.currentLen - this.currentPos;
        if (rem >= 8) {
            this.currentPos += 8;
            return;
        }
        this.currentPos = this.currentLen;
        try {
            this.input.skip(8 - rem);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readAsync(buffer, ondone, false);
    }

    private AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone, boolean isCurrent) {
        if (this.error != null) {
            if (ondone != null) {
                ondone.run((Object)new Pair(null, (Object)this.error));
            }
            return new AsyncWork(null, (Exception)this.error);
        }
        if (!this.header.isUnblocked()) {
            AsyncWork res;
            this.currentRead = res = new AsyncWork();
            this.header.listenInline(() -> this.readAsync(buffer, ondone, true).listenInline(res));
            return (AsyncWork)this.operation((ISynchronizationPoint)res);
        }
        if (this.eof) {
            if (ondone != null) {
                ondone.run((Object)new Pair((Object)-1, null));
            }
            return new AsyncWork((Object)-1, null);
        }
        if (!isCurrent && this.currentRead != null && !this.currentRead.isUnblocked()) {
            AsyncWork result = new AsyncWork();
            AsyncWork<Integer, IOException> previous = this.currentRead;
            this.currentRead = result;
            previous.listenInline(() -> this.readAsync(buffer, ondone, true).listenInline(result));
            return (AsyncWork)this.operation((ISynchronizationPoint)result);
        }
        if (!this.inflater.needsInput()) {
            AsyncWork result = new AsyncWork();
            InflateTask inflate = new InflateTask(buffer, result, ondone, false);
            this.currentRead = result;
            this.operation(inflate.start());
            if (inflate.isCancelling()) {
                result.cancel(inflate.getCancelEvent());
            }
            return result;
        }
        AsyncWork result = new AsyncWork();
        if (this.currentPos == this.currentLen) {
            this.currentRead = result;
            this.nextBuffer().listenInline(() -> this.readAsync(buffer, ondone, true).listenInline(result));
            return (AsyncWork)this.operation((ISynchronizationPoint)result);
        }
        InflateTask inflate = new InflateTask(buffer, result, ondone, true);
        this.currentRead = result;
        this.operation(inflate.start());
        if (inflate.isCancelling()) {
            result.cancel(inflate.getCancelEvent());
        }
        return result;
    }

    public String getSourceDescription() {
        return "GZIP: " + this.input.getSourceDescription();
    }

    public IO getWrappedIO() {
        return null;
    }

    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    public int readSync(ByteBuffer buffer) throws IOException {
        try {
            return (Integer)this.readAsync(buffer).blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Operation cancelled", e);
        }
    }

    public int readFullySync(ByteBuffer buffer) throws IOException {
        try {
            return (Integer)this.readFullyAsync(buffer).blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Operation cancelled", e);
        }
    }

    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return (AsyncWork)this.operation((ISynchronizationPoint)IOUtil.readFullyAsync((IO.Readable)this, (ByteBuffer)buffer, ondone));
    }

    public long skipSync(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        return IOUtil.skipSyncByReading((IO.Readable)this, (long)n);
    }

    public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return (AsyncWork)this.operation((ISynchronizationPoint)IOUtil.skipAsyncByReading((IO.Readable)this, (long)n, ondone));
    }

    static /* synthetic */ byte[] access$202(GZipReadable x0, byte[] x1) {
        x0.currentBuffer = x1;
        return x1;
    }

    private class InflateTask
    extends Task.Cpu<Void, NoException> {
        private ByteBuffer buffer;
        private AsyncWork<Integer, IOException> result;
        private RunnableWithParameter<Pair<Integer, IOException>> ondone;
        private boolean setInput;

        private InflateTask(ByteBuffer buffer, AsyncWork<Integer, IOException> result, RunnableWithParameter<Pair<Integer, IOException>> ondone, boolean setInput) {
            super("Uncompressing gzip: " + GZipReadable.this.input.getSourceDescription(), GZipReadable.this.priority);
            this.buffer = buffer;
            this.result = result;
            this.ondone = ondone;
            this.setInput = setInput;
        }

        public Void run() {
            int off;
            byte[] b;
            if (GZipReadable.this.isClosing() || GZipReadable.this.isClosed() || GZipReadable.this.input == null) {
                this.result.cancel(new CancelException("GZip closed"));
                return null;
            }
            if (this.setInput) {
                GZipReadable.this.inflater.setInput(GZipReadable.this.currentBuffer, GZipReadable.this.currentPos, GZipReadable.this.currentLen - GZipReadable.this.currentPos);
                GZipReadable.this.currentPos = GZipReadable.this.currentLen;
            }
            if (this.buffer.hasArray()) {
                b = this.buffer.array();
                off = this.buffer.arrayOffset() + this.buffer.position();
            } else {
                b = new byte[this.buffer.remaining()];
                off = 0;
            }
            try {
                int n;
                int total = 0;
                do {
                    if (GZipReadable.this.isClosing() || GZipReadable.this.isClosed() || GZipReadable.this.input == null) {
                        this.result.cancel(new CancelException("GZip closed"));
                        return null;
                    }
                    n = GZipReadable.this.inflater.inflate(b, off + total, this.buffer.remaining() - total);
                    if (n > 0) {
                        total += n;
                    }
                    if (GZipReadable.this.inflater.finished() || GZipReadable.this.inflater.needsDictionary()) {
                        GZipReadable.this.currentPos = GZipReadable.this.currentLen - GZipReadable.this.inflater.getRemaining();
                        GZipReadable.this.skipTrailer();
                        GZipReadable.this.header = new SynchronizationPoint();
                        GZipReadable.this.readHeader();
                        GZipReadable.this.inflater.reset();
                        if (total > 0) break;
                        GZipReadable.this.header.listenInline(() -> GZipReadable.this.readAsync(this.buffer, (RunnableWithParameter<Pair<Integer, IOException>>)this.ondone, true).listenInline(this.result));
                        return null;
                    }
                    if (!GZipReadable.this.inflater.needsInput()) continue;
                    if (total > 0) break;
                    GZipReadable.this.readAsync(this.buffer, (RunnableWithParameter<Pair<Integer, IOException>>)this.ondone, true).listenInline(this.result);
                    return null;
                } while (n > 0 && total < this.buffer.remaining() && !GZipReadable.this.inflater.needsInput());
                if (!this.buffer.hasArray()) {
                    this.buffer.put(b, 0, total);
                } else {
                    this.buffer.position(off + total - this.buffer.arrayOffset());
                }
                Integer r = total;
                if (this.ondone != null) {
                    this.ondone.run((Object)new Pair((Object)r, null));
                }
                this.result.unblockSuccess((Object)r);
                return null;
            }
            catch (DataFormatException e) {
                GZipReadable.this.error = new IOException("Invalid compressed data after " + GZipReadable.this.inflater.getBytesRead() + " bytes (" + GZipReadable.this.inflater.getBytesWritten() + " uncompressed)", e);
                if (this.ondone != null) {
                    this.ondone.run((Object)new Pair(null, (Object)GZipReadable.this.error));
                }
                this.result.error((Exception)GZipReadable.this.error);
                return null;
            }
        }
    }

    public static class SizeKnown
    extends GZipReadable
    implements IO.KnownSize {
        private long uncompressedSize;

        public SizeKnown(IO.Readable.Buffered input, byte priority, long uncompressedSize) {
            super(input, priority);
            this.uncompressedSize = uncompressedSize;
        }

        public AsyncWork<Long, IOException> getSizeAsync() {
            return new AsyncWork((Object)this.uncompressedSize, null);
        }

        public long getSizeSync() {
            return this.uncompressedSize;
        }
    }
}

