/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.compression.gzip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import net.lecousin.compression.deflate.DeflateWritable;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.DataUtil;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class GZipWritable
extends DeflateWritable {
    private SynchronizationPoint<IOException> writeHeader = new SynchronizationPoint();
    private CRC32 crc = new CRC32();

    public GZipWritable(IO.Writable out, byte priority, int level, int maxPendingWrites) {
        super(out, priority, level, true, maxPendingWrites);
        this.writeHeader();
        this.crc.reset();
    }

    public ISynchronizationPoint<IOException> canStartWriting() {
        return this.writeHeader;
    }

    public int writeSync(ByteBuffer buffer) throws IOException {
        this.writeHeader.blockException(0L);
        int pos = buffer.position();
        this.crc.update(buffer);
        buffer.position(pos);
        return super.writeSync(buffer);
    }

    public AsyncWork<Integer, IOException> writeAsync(final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (this.writeHeader.hasError()) {
            if (ondone != null) {
                ondone.run((Object)new Pair(null, (Object)this.writeHeader.getError()));
            }
            return new AsyncWork(null, this.writeHeader.getError());
        }
        if (!this.writeHeader.isUnblocked()) {
            AsyncWork result = new AsyncWork();
            this.writeHeader.listenInline(() -> this.writeAsync(buffer, ondone).listenInline(result));
            return (AsyncWork)this.operation((ISynchronizationPoint)result);
        }
        final int initPos = buffer.position();
        final AsyncWork write = super.writeAsync(buffer, null);
        final AsyncWork result = new AsyncWork();
        (this.operation((Task)new Task.Cpu<Void, NoException>("Update GZip CRC", this.getPriority()){

            public Void run() {
                if (write.hasError()) {
                    result.error(write.getError());
                    return null;
                }
                if (write.isCancelled()) {
                    result.cancel(write.getCancelEvent());
                    return null;
                }
                int nb = (Integer)write.getResult();
                if (nb <= 0) {
                    result.unblockSuccess(write.getResult());
                    return null;
                }
                int newPos = buffer.position();
                int limit = buffer.limit();
                buffer.position(initPos);
                buffer.limit(initPos + nb);
                GZipWritable.this.crc.update(buffer);
                buffer.limit(limit);
                buffer.position(newPos);
                result.unblockSuccess(write.getResult());
                return null;
            }
        })).startOn((ISynchronizationPoint)write, true);
        return result;
    }

    public void finishSynch() throws IOException {
        this.writeHeader.blockException(0L);
        super.finishSynch();
        byte[] trailer = new byte[8];
        DataUtil.writeUnsignedIntegerLittleEndian((byte[])trailer, (int)0, (long)((int)this.crc.getValue()));
        DataUtil.writeUnsignedIntegerLittleEndian((byte[])trailer, (int)4, (long)this.deflater.getTotalIn());
        this.output.writeSync(ByteBuffer.wrap(trailer));
    }

    public ISynchronizationPoint<IOException> finishAsync() {
        final SynchronizationPoint result = new SynchronizationPoint();
        if (this.writeHeader.hasError()) {
            result.error(this.writeHeader.getError());
            return result;
        }
        if (!this.writeHeader.isUnblocked()) {
            this.writeHeader.listenInline(() -> {
                if (this.writeHeader.hasError()) {
                    result.error(this.writeHeader.getError());
                } else {
                    this.finishAsync().listenInline(result);
                }
            });
            return this.operation((ISynchronizationPoint)result);
        }
        ISynchronizationPoint finish = super.finishAsync();
        finish.listenInline(() -> {
            if (finish.hasError()) {
                result.error(finish.getError());
            } else if (finish.isCancelled()) {
                result.cancel(finish.getCancelEvent());
            } else {
                new Task.Cpu<Void, NoException>("Write GZip trailer", this.getPriority()){

                    public Void run() {
                        byte[] trailer = new byte[8];
                        DataUtil.writeUnsignedIntegerLittleEndian((byte[])trailer, (int)0, (long)((int)GZipWritable.this.crc.getValue()));
                        DataUtil.writeUnsignedIntegerLittleEndian((byte[])trailer, (int)4, (long)GZipWritable.this.deflater.getTotalIn());
                        GZipWritable.this.output.writeAsync(ByteBuffer.wrap(trailer)).listenInline(result);
                        return null;
                    }
                }.start();
            }
        });
        return this.operation((ISynchronizationPoint)result);
    }

    private void writeHeader() {
        new Task.Cpu<Void, NoException>("Prepare GZip header", this.getPriority()){

            public Void run() {
                byte[] header = new byte[10];
                header[0] = 31;
                header[1] = -117;
                header[2] = 8;
                header[3] = 0;
                DataUtil.writeUnsignedIntegerLittleEndian((byte[])header, (int)4, (long)(System.currentTimeMillis() / 1000L));
                header[8] = 0;
                header[9] = 0;
                GZipWritable.this.output.writeAsync(ByteBuffer.wrap(header)).listenInline(GZipWritable.this.writeHeader);
                return null;
            }
        }.start();
    }
}

