/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import net.lecousin.framework.adapter.Adapter;
import net.lecousin.framework.adapter.AdapterException;
import net.lecousin.framework.adapter.FileInfoToFile;
import net.lecousin.framework.adapter.FileInfoToPath;
import net.lecousin.framework.adapter.FileToIO;
import net.lecousin.framework.adapter.LinkedAdapter;
import net.lecousin.framework.plugins.ExtensionPoint;

public class AdapterRegistry
implements ExtensionPoint<Adapter> {
    private static AdapterRegistry instance;
    private ArrayList<Adapter> adapters = new ArrayList();

    public static AdapterRegistry get() {
        if (instance == null) {
            instance = new AdapterRegistry();
            AdapterRegistry.instance.adapters.add(new FileToIO.Writable());
            AdapterRegistry.instance.adapters.add(new FileToIO.Readable());
            AdapterRegistry.instance.adapters.add(new FileInfoToFile());
            AdapterRegistry.instance.adapters.add(new FileInfoToPath());
        }
        return instance;
    }

    private AdapterRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlugin(Adapter plugin) {
        ArrayList<Adapter> arrayList = this.adapters;
        synchronized (arrayList) {
            this.adapters.add(plugin);
        }
    }

    @Override
    public void allPluginsLoaded() {
    }

    @Override
    public Collection<Adapter> getPlugins() {
        return this.adapters;
    }

    @Override
    public Class<Adapter> getPluginClass() {
        return Adapter.class;
    }

    public <Input, Output> Output adapt(Input input, Class<Output> outputType) throws AdapterException {
        Class<?> inputType = input.getClass();
        Adapter<?, Output> a = this.findAdapter(input, inputType, outputType);
        if (a == null) {
            return null;
        }
        return a.adapt(input);
    }

    public boolean canAdapt(Object input, Class<?> outputType) {
        Class<?> inputType = input.getClass();
        Adapter<?, ?> a = this.findAdapter(input, inputType, outputType);
        return a != null;
    }

    public <Input, Output> Adapter<Input, Output> findAdapter(Object in, Class<Input> input, Class<Output> output) {
        ArrayList<Adapter> acceptInput = new ArrayList<Adapter>();
        ArrayList<Adapter> matching = new ArrayList<Adapter>();
        for (Adapter a : this.adapters) {
            if (!a.getInputType().isAssignableFrom(input) || !a.canAdapt(in)) continue;
            acceptInput.add(a);
            if (output.equals(a.getOutputType())) {
                return a;
            }
            if (!output.isAssignableFrom(a.getOutputType())) continue;
            matching.add(a);
        }
        if (acceptInput.isEmpty()) {
            return null;
        }
        if (matching.size() == 1) {
            return (Adapter)matching.get(0);
        }
        if (!matching.isEmpty()) {
            return AdapterRegistry.getBest(matching);
        }
        LinkedList<LinkedList<Adapter>> paths = this.findPathsTo(input, acceptInput, output);
        LinkedList<Adapter> best = AdapterRegistry.getBestPath(in, paths);
        if (best == null) {
            return null;
        }
        return new LinkedAdapter(best);
    }

    private static LinkedList<Adapter> getBestPath(Object in, LinkedList<LinkedList<Adapter>> paths) {
        LinkedList<Adapter> best = null;
        while (!paths.isEmpty()) {
            LinkedList<Adapter> path = paths.removeFirst();
            if (best != null && best.size() <= path.size() || !AdapterRegistry.isPathValid(in, path)) continue;
            best = path;
        }
        return best;
    }

    private static boolean isPathValid(Object in, LinkedList<Adapter> path) {
        Object o = in;
        ListIterator it = path.listIterator();
        while (it.nextIndex() < path.size() - 1) {
            Adapter a = (Adapter)it.next();
            if (!a.canAdapt(o)) {
                return false;
            }
            try {
                o = a.adapt(o);
            }
            catch (Exception e) {
                return false;
            }
        }
        return ((Adapter)it.next()).canAdapt(o);
    }

    private static Adapter getBest(ArrayList<Adapter> list) {
        Adapter best = list.get(0);
        Class bestType = best.getOutputType();
        for (int i = 1; i < list.size(); ++i) {
            Adapter a = list.get(i);
            Class type = a.getOutputType();
            if (!bestType.isAssignableFrom(type)) continue;
            bestType = type;
            best = a;
        }
        return best;
    }

    private LinkedList<LinkedList<Adapter>> findPathsTo(Class<?> origin, ArrayList<Adapter> canUse, Class<?> target) {
        LinkedList<LinkedList<Adapter>> paths = new LinkedList<LinkedList<Adapter>>();
        ArrayList used = new ArrayList(1);
        used.add(origin);
        for (Adapter a : canUse) {
            Class type = a.getOutputType();
            LinkedList<LinkedList<Adapter>> subPaths = this.findPaths(type, target, used);
            for (LinkedList linkedList : subPaths) {
                linkedList.addFirst(a);
                paths.add(linkedList);
            }
        }
        return paths;
    }

    private LinkedList<LinkedList<Adapter>> findPaths(Class<?> from, Class<?> to, ArrayList<Class<?>> used) {
        LinkedList<LinkedList<Adapter>> paths = new LinkedList<LinkedList<Adapter>>();
        ArrayList<Adapter> possible = this.getPossibleStarts(from, to, used, paths);
        if (possible.isEmpty()) {
            return paths;
        }
        ArrayList newUsed = new ArrayList(used.size() + 1);
        newUsed.addAll(used);
        newUsed.add(from);
        for (Adapter a : possible) {
            LinkedList<LinkedList<Adapter>> subPaths = this.findPaths(a.getOutputType(), to, newUsed);
            for (LinkedList linkedList : subPaths) {
                linkedList.addFirst(a);
                paths.add(linkedList);
            }
        }
        return paths;
    }

    private ArrayList<Adapter> getPossibleStarts(Class<?> from, Class<?> to, ArrayList<Class<?>> used, LinkedList<LinkedList<Adapter>> paths) {
        ArrayList<Adapter> possible = new ArrayList<Adapter>();
        for (Adapter a : this.adapters) {
            if (!a.getInputType().isAssignableFrom(from)) continue;
            Class out = a.getOutputType();
            if (to.isAssignableFrom(out)) {
                LinkedList<Adapter> list = new LinkedList<Adapter>();
                list.add(a);
                paths.add(list);
                continue;
            }
            if (AdapterRegistry.containsOutputType(used, out)) continue;
            possible.add(a);
        }
        return possible;
    }

    private static boolean containsOutputType(ArrayList<Class<?>> used, Class<?> out) {
        for (Class<?> c : used) {
            if (!c.isAssignableFrom(out) && !out.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }
}

