/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.application.ApplicationBootstrapException;

public class ApplicationConfiguration {
    private String splash;
    private String name;
    private String clazz;
    private Map<String, String> properties = new HashMap<String, String>();

    public String getSplash() {
        return this.splash;
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApplicationConfiguration load(File file) throws ApplicationBootstrapException {
        try (FileInputStream in = new FileInputStream(file);){
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.load(in);
            return applicationConfiguration;
        }
        catch (IOException e) {
            throw new ApplicationBootstrapException("Error reading lc-project.xml file", e);
        }
    }

    public static ApplicationConfiguration load(InputStream input) throws ApplicationBootstrapException {
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader xml = factory.createXMLStreamReader(input);
            if (ApplicationConfiguration.nextStartElement(xml)) {
                if (!"project".equals(xml.getLocalName())) {
                    throw new ApplicationBootstrapException("Root element of an lc-project.xml file must be <project>");
                }
                ApplicationConfiguration cfg = new ApplicationConfiguration();
                while (ApplicationConfiguration.nextStartElement(xml)) {
                    if (!"application".equals(xml.getLocalName())) continue;
                    cfg.loadApplication(xml);
                    return cfg;
                }
                throw new ApplicationBootstrapException("No application element found in lc-project.xml file");
            }
        }
        catch (XMLStreamException e) {
            throw new ApplicationBootstrapException("Error reading lc-project.xml file", e);
        }
        throw new ApplicationBootstrapException("Nothing found in lc-project.xml file");
    }

    private static boolean nextStartElement(XMLStreamReader xml) throws XMLStreamException {
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() == 1) {
                return true;
            }
            if (xml.getEventType() != 2) continue;
            return false;
        }
        return false;
    }

    private void loadApplication(XMLStreamReader xml) throws XMLStreamException {
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() != 1) continue;
            if ("name".equals(xml.getLocalName())) {
                this.name = xml.getElementText();
                continue;
            }
            if ("class".equals(xml.getLocalName())) {
                this.clazz = xml.getElementText();
                continue;
            }
            if ("splash".equals(xml.getLocalName())) {
                this.splash = xml.getElementText();
                continue;
            }
            if ("properties".equals(xml.getLocalName())) {
                this.loadProperties(xml);
                continue;
            }
            throw new XMLStreamException("Unknown element <" + xml.getLocalName() + "> in application");
        }
    }

    private void loadProperties(XMLStreamReader xml) throws XMLStreamException {
        while (ApplicationConfiguration.nextStartElement(xml)) {
            String propName = xml.getLocalName();
            String propValue = xml.getElementText();
            this.properties.put(propName, propValue);
        }
    }
}

