/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import net.lecousin.framework.application.ArtifactReference;
import net.lecousin.framework.application.Version;

public class Artifact
extends ArtifactReference {
    private Version version;

    public Artifact(String groupId, String artifactId, Version version) {
        super(groupId, artifactId);
        this.version = version;
    }

    public Artifact(Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.version);
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact a = (Artifact)obj;
        return this.getGroupId().equals(a.getGroupId()) && this.getArtifactId().equals(a.getArtifactId()) && this.version.equals(a.version);
    }

    public int hashCode() {
        return this.getGroupId().hashCode() + this.getArtifactId().hashCode();
    }

    public String toString() {
        return Artifact.toString(this.getGroupId(), this.getArtifactId(), this.version.toString());
    }

    public static void toString(StringBuilder s, String groupId, String artifactId, String version) {
        s.append(groupId).append(':').append(artifactId).append(':').append(version);
    }

    public static String toString(String groupId, String artifactId, String version) {
        StringBuilder s = new StringBuilder(groupId.length() + artifactId.length() + version.length() + 2);
        Artifact.toString(s, groupId, artifactId, version);
        return s.toString();
    }
}

