/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.DrivesThreadingManager;
import net.lecousin.framework.concurrent.threads.TaskManagerMonitor;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.concurrent.threads.priority.SimpleTaskPriorityManager;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.DebugUtil;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.ThreadUtil;

public class StandaloneLCCore
implements LCCore.Environment {
    private Application app = null;
    private long startTime;
    private boolean closing;
    private List<Thread> threadsBeforeInit = new LinkedList<Thread>();
    private ArrayList<Closeable> toCloseSync = new ArrayList();
    private ArrayList<AsyncCloseable<?>> toCloseAsync = new ArrayList();
    private int nbCPUThreads = -1;
    private int nbUnmanagedThreads = -1;
    private DrivesThreadingManager.DrivesProvider drivesProvider = null;
    private TaskManagerMonitor.Configuration cpuMonitorConfig = new TaskManagerMonitor.Configuration(60000, 300000, 900000, false);
    private TaskManagerMonitor.Configuration driveMonitorConfig = new TaskManagerMonitor.Configuration(30000, 60000, 900000, false);
    private TaskManagerMonitor.Configuration unmanagedMonitorConfig = new TaskManagerMonitor.Configuration(60000, 300000, 900000, false);
    private static final String ERROR_ALREADY_INITIALIZED = "Threading has been already initialized.";
    private static long logThreadingInterval = 30000L;

    public StandaloneLCCore() {
        System.out.println("net.lecousin.framework 0.20.0");
        this.startTime = System.nanoTime();
        this.closing = false;
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> thread : threads.entrySet()) {
            this.threadsBeforeInit.add(thread.getKey());
        }
        threads = null;
    }

    @Override
    public void add(Application app) {
        if (this.app != null) {
            throw new IllegalStateException("Cannot add several application on a standalone LCCore environment");
        }
        this.app = app;
    }

    public void setCPUThreads(int nbThreads) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException(ERROR_ALREADY_INITIALIZED);
        }
        this.nbCPUThreads = nbThreads;
    }

    public void setUnmanagedThreads(int nbThreads) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException(ERROR_ALREADY_INITIALIZED);
        }
        this.nbUnmanagedThreads = nbThreads;
    }

    public void setDrivesProvider(DrivesThreadingManager.DrivesProvider provider) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException(ERROR_ALREADY_INITIALIZED);
        }
        this.drivesProvider = provider;
    }

    public void setCpuMonitorConfig(TaskManagerMonitor.Configuration config) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException(ERROR_ALREADY_INITIALIZED);
        }
        this.cpuMonitorConfig = config;
    }

    public void setDriveMonitorConfig(TaskManagerMonitor.Configuration config) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException(ERROR_ALREADY_INITIALIZED);
        }
        this.driveMonitorConfig = config;
    }

    public void setUnmanagedMonitorConfig(TaskManagerMonitor.Configuration config) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException(ERROR_ALREADY_INITIALIZED);
        }
        this.unmanagedMonitorConfig = config;
    }

    public static void setLogThreadingInterval(long interval) {
        logThreadingInterval = interval;
    }

    @Override
    public void start() {
        Logger logger;
        Threading.init(this.app.getThreadFactory(), SimpleTaskPriorityManager.class, this.nbCPUThreads, this.cpuMonitorConfig, this.drivesProvider, this.driveMonitorConfig, this.nbUnmanagedThreads, this.unmanagedMonitorConfig);
        if (this.app.isDebugMode() && (logger = this.app.getLoggerFactory().getLogger("Threading Status")).debug()) {
            class ThreadingLogger
            extends Thread
            implements Closeable {
                private boolean closed;
                private final Object lock;

                ThreadingLogger() {
                    super("Threading logger");
                    this.closed = false;
                    this.lock = new Object();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Object object = this.lock;
                        synchronized (object) {
                            if (!ThreadUtil.wait(this.lock, logThreadingInterval)) {
                                return;
                            }
                        }
                        if (this.closed) {
                            return;
                        }
                        logger.debug("\n" + Threading.debug());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    Object object = this.lock;
                    synchronized (object) {
                        this.closed = true;
                        this.lock.notify();
                    }
                }
            }
            ThreadingLogger t = new ThreadingLogger();
            t.start();
            this.app.toClose(0, t);
        }
    }

    @Override
    public Application getApplication() {
        return this.app;
    }

    @Override
    public Logger getSystemLogger(String name) {
        return this.app.getLoggerFactory().getLogger(name);
    }

    @Override
    public LibrariesManager getSystemLibraries() {
        return this.app.getLibrariesManager();
    }

    @Override
    public boolean currentThreadIsSystem() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toClose(Closeable c) {
        ArrayList<Closeable> arrayList = this.toCloseSync;
        synchronized (arrayList) {
            this.toCloseSync.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toClose(AsyncCloseable<?> c) {
        ArrayList<AsyncCloseable<?>> arrayList = this.toCloseAsync;
        synchronized (arrayList) {
            this.toCloseAsync.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(Closeable c) {
        ArrayList<Closeable> arrayList = this.toCloseSync;
        synchronized (arrayList) {
            this.toCloseSync.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(AsyncCloseable<?> c) {
        ArrayList<AsyncCloseable<?>> arrayList = this.toCloseAsync;
        synchronized (arrayList) {
            this.toCloseAsync.remove(c);
        }
    }

    @Override
    public boolean isStopping() {
        return this.closing;
    }

    @Override
    public void stop() {
        block11: {
            this.closing = true;
            if (!this.app.isStopping()) {
                this.app.stop();
            }
            System.out.println(" * Closing resources");
            for (Closeable closeable : new ArrayList<Closeable>(this.toCloseSync)) {
                System.out.println("     - " + closeable);
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    System.err.println("Error closing resource " + closeable);
                    exception.printStackTrace(System.err);
                }
            }
            LinkedList closingResources = new LinkedList();
            for (AsyncCloseable<?> asyncCloseable : new ArrayList(this.toCloseAsync)) {
                System.out.println(" * Closing " + asyncCloseable);
                closingResources.add(new Pair(asyncCloseable, asyncCloseable.closeAsync()));
            }
            this.toCloseAsync.clear();
            long l = System.currentTimeMillis();
            do {
                Iterator it = closingResources.iterator();
                while (it.hasNext()) {
                    Pair s = (Pair)it.next();
                    if (!((IAsync)s.getValue2()).isDone()) continue;
                    System.out.println(" * Closed: " + s.getValue1());
                    it.remove();
                }
                if (closingResources.isEmpty() || !ThreadUtil.sleep(100L)) break block11;
            } while (System.currentTimeMillis() - l <= 15000L);
            System.out.println("Ressources are still closing, but we don't wait more than 15 seconds.");
        }
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        int count = 0;
        do {
            int nb = 0;
            if (count % 10 == 0) {
                System.out.println("Threads still running:");
            }
            for (Map.Entry<Thread, StackTraceElement[]> thread : threads.entrySet()) {
                ThreadGroup g;
                if (thread.getKey() == Thread.currentThread() || (g = thread.getKey().getThreadGroup()) == null || "system".equals(g.getName()) || "DestroyJavaVM".equals(thread.getKey().getName()) || thread.getKey().getName().startsWith("AWT-")) continue;
                if (this.threadsBeforeInit.contains(thread.getKey())) {
                    if (count % 10 != 0) continue;
                    System.out.println("Thread ignored because started before: " + thread.getKey());
                    continue;
                }
                ++nb;
                if (count % 10 != 0) continue;
                System.out.println("Thread: " + thread.getKey() + " [id " + thread.getKey().getId() + "]");
                System.out.println(DebugUtil.createStackTrace(new StringBuilder(), thread.getValue()).toString());
            }
            if (nb == 0) break;
            if (count % 10 != 0) continue;
            System.out.println("Waiting for threads to stop");
        } while (ThreadUtil.sleep(100L) && ++count < 50);
        long end = System.nanoTime();
        StringBuilder s = new StringBuilder(2048);
        MemoryManager.logMemory(s);
        System.out.println(s.toString());
        System.out.println("JVM has run during " + String.format("%.5f", (double)(end - this.startTime) * 1.0 / 1.0E9) + "s.");
    }
}

