/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.lecousin.framework.application.launcher.Launcher;
import net.lecousin.framework.application.launcher.LauncherService;
import net.lecousin.framework.util.CommandLine;

public class DevLauncher
implements LauncherService {
    public static final String EXTENSION_PROJECTS = "dev.projects";

    @Override
    public void addCommandLineArgumentsConsumers(List<CommandLine.ArgumentsConsumer<Launcher.CommandLineContext>> consumers) {
        consumers.add(new ProjectsConsumer());
    }

    @Override
    public void printOptionsUsage() {
        System.out.println("[-projects=<paths>]                Paths to search for development projects");
        System.out.println("                                   using operating system separator");
    }

    @Override
    public boolean checkCommandLineContext(Launcher.CommandLineContext context, List<String> errors) {
        if (!context.extensions.containsKey(EXTENSION_PROJECTS)) {
            return false;
        }
        String[] s = ((String)context.extensions.get(EXTENSION_PROJECTS)).split(File.pathSeparator);
        ArrayList<File> devPaths = new ArrayList<File>(s.length);
        for (String path : s) {
            File dir = new File(path);
            if (!dir.exists()) {
                System.err.println("Development path " + path + " does not exist");
                continue;
            }
            devPaths.add(dir);
        }
        context.extensions.put(EXTENSION_PROJECTS, devPaths);
        return !devPaths.isEmpty();
    }

    @Override
    public void getSearchProjectsPaths(Launcher.CommandLineContext context, List<File> path) {
        path.addAll((ArrayList)context.extensions.get(EXTENSION_PROJECTS));
    }

    @Override
    public boolean activeDebugMode(Launcher.CommandLineContext context) {
        return true;
    }

    private static class ProjectsConsumer
    implements CommandLine.ArgumentsConsumer<Launcher.CommandLineContext> {
        private ProjectsConsumer() {
        }

        @Override
        public boolean matches(String arg, Launcher.CommandLineContext context) {
            return arg.startsWith("-projects=");
        }

        @Override
        public int consume(String[] args, int index, Launcher.CommandLineContext context) {
            if (context.extensions.containsKey(DevLauncher.EXTENSION_PROJECTS)) {
                throw new IllegalArgumentException("Option -projects cannot be specified several times");
            }
            context.extensions.put(DevLauncher.EXTENSION_PROJECTS, args[index].substring(10));
            return 1;
        }
    }
}

